/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.drowned;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.config.species.DrownedSpeciesConfig;
import fathertoast.specialmobs.common.config.species.SpeciesConfig;
import fathertoast.specialmobs.common.entity.ISpecialMob;
import fathertoast.specialmobs.common.entity.MobHelper;
import fathertoast.specialmobs.common.entity.SpecialMobData;
import fathertoast.specialmobs.common.entity.ai.AIHelper;
import fathertoast.specialmobs.common.entity.ai.goal.SpecialDrownedAttackGoal;
import fathertoast.specialmobs.common.entity.ai.goal.SpecialHurtByTargetGoal;
import fathertoast.specialmobs.common.entity.ai.goal.SpecialTridentAttackGoal;
import fathertoast.specialmobs.common.event.NaturalSpawnManager;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.monster.DrownedEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.monster.ZombifiedPiglinEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.SnowballEntity;
import net.minecraft.entity.projectile.TridentEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;

@SpecialMob
public class _SpecialDrownedEntity
extends DrownedEntity
implements ISpecialMob<_SpecialDrownedEntity> {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<_SpecialDrownedEntity> SPECIES;
    protected static final double DEFAULT_TRIDENT_CHANCE = 0.0625;
    protected static final double DEFAULT_SHIELD_CHANCE = 0.0625;
    private static final DataParameter<Float> SCALE;
    private boolean needsToBeDeeper;
    private SpecialMobData<_SpecialDrownedEntity> specialData;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(7969893).vanillaTextureWithOverlay("textures/entity/zombie/drowned.png", "textures/entity/zombie/drowned_outer_layer.png").experience(5).undead().throwAttack(1.0, 1.0, 40, 10.0);
    }

    @SpecialMob.ConfigSupplier
    public static SpeciesConfig createConfig(MobFamily.Species<?> species) {
        return new DrownedSpeciesConfig(species, 0.0625, 0.0625);
    }

    public DrownedSpeciesConfig getConfig() {
        return (DrownedSpeciesConfig)this.getSpecies().config;
    }

    @SpecialMob.AttributeSupplier
    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return DrownedEntity.func_234342_eQ_();
    }

    @SpecialMob.SpawnPlacementRegistrar
    public static void registerSpawnPlacement(MobFamily.Species<? extends _SpecialDrownedEntity> species) {
        NaturalSpawnManager.registerSpawnPlacement(species, EntitySpawnPlacementRegistry.PlacementType.IN_WATER, _SpecialDrownedEntity::checkFamilySpawnRules);
    }

    public static boolean checkFamilySpawnRules(EntityType<? extends DrownedEntity> type, IServerWorld world, SpawnReason reason, BlockPos pos, Random random) {
        return DrownedEntity.func_223332_b(type, (IServerWorld)world, (SpawnReason)reason, (BlockPos)pos, (Random)random) && NaturalSpawnManager.checkSpawnRulesConfigured(type, world, reason, pos, random);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Drowned", "Ahogado", "Afogado", "Noy\u00c3\u00a9", "Annegato", "Ertrunkener", "Sunken Sailor");
    }

    @SpecialMob.LootTableProvider
    public static void addBaseLoot(LootTableBuilder loot) {
        loot.addLootTable("main", EntityType.field_204724_o.func_220348_g());
    }

    @SpecialMob.Factory
    public static EntityType.IFactory<_SpecialDrownedEntity> getFactory() {
        return _SpecialDrownedEntity::new;
    }

    protected void func_184651_r() {
        super.func_184651_r();
        AIHelper.removeGoals(this.field_70714_bg, 2);
        this.field_70714_bg.func_75776_a(2, (Goal)new SpecialDrownedAttackGoal(this, 1.0, false));
        AIHelper.replaceHurtByTarget((CreatureEntity)this, new SpecialHurtByTargetGoal((CreatureEntity)this, ZombieEntity.class, DrownedEntity.class).setAlertOthers(ZombifiedPiglinEntity.class));
        this.registerVariantGoals();
    }

    protected void registerVariantGoals() {
    }

    public void finalizeVariantSpawn(IServerWorld world, DifficultyInstance difficulty, @Nullable SpawnReason spawnReason, @Nullable ILivingEntityData groupData) {
    }

    public void func_174815_a(LivingEntity attacker, Entity target) {
        if (target instanceof LivingEntity) {
            this.onVariantAttack((LivingEntity)target);
        }
        super.func_174815_a(attacker, target);
    }

    protected void onVariantAttack(LivingEntity target) {
    }

    public void addVariantSaveData(CompoundNBT saveTag) {
    }

    public void readVariantSaveData(CompoundNBT saveTag) {
    }

    public _SpecialDrownedEntity(EntityType<? extends _SpecialDrownedEntity> entityType, World world) {
        super(entityType, world);
        this.recalculateAttackGoal();
        this.getSpecialData().initialize();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.specialData = new SpecialMobData<_SpecialDrownedEntity>(this, SCALE);
    }

    public void recalculateAttackGoal() {
        if (this.field_70170_p != null && !this.field_70170_p.field_72995_K) {
            AIHelper.removeGoals(this.field_70714_bg, SpecialTridentAttackGoal.class);
            if (this.getSpecialData().getRangedAttackMaxRange() > 0.0f) {
                this.field_70714_bg.func_75776_a(2, (Goal)new SpecialTridentAttackGoal((IRangedAttackMob)this, this.getSpecialData().getRangedWalkSpeed(), this.getSpecialData().getRangedAttackCooldown(), this.getSpecialData().getRangedAttackMaxRange()));
            }
        }
    }

    public void func_82196_d(LivingEntity target, float damageMulti) {
        TridentEntity trident = new TridentEntity(this.field_70170_p, (LivingEntity)this, new ItemStack((IItemProvider)Items.field_203184_eO));
        double dX = target.func_226277_ct_() - this.func_226277_ct_();
        double dY = target.func_226283_e_(0.3333) - trident.func_226278_cu_();
        double dZ = target.func_226281_cx_() - this.func_226281_cx_();
        double dH = MathHelper.func_76133_a((double)(dX * dX + dZ * dZ));
        trident.func_70186_c(dX, dY + dH * 0.2, dZ, 1.6f, this.getSpecialData().getRangedAttackSpread() * (float)(14 - this.field_70170_p.func_175659_aa().func_151525_a() * 4));
        this.func_184185_a(SoundEvents.field_204780_be, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_217376_c((Entity)trident);
    }

    public void func_205343_av() {
        if (!this.field_70170_p.field_72995_K && this.func_70613_aW()) {
            this.needsToBeDeeper = true;
        }
        super.func_205343_av();
    }

    public void func_213352_e(Vector3d input) {
        if (this.func_70613_aW()) {
            this.needsToBeDeeper = true;
        }
        super.func_213352_e(input);
    }

    public boolean func_70090_H() {
        if (this.needsToBeDeeper) {
            this.needsToBeDeeper = false;
            return this.func_204231_K();
        }
        return super.func_70090_H();
    }

    protected float func_189749_co() {
        return 0.9f;
    }

    @Override
    public SpecialMobData<_SpecialDrownedEntity> getSpecialData() {
        return this.specialData;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends _SpecialDrownedEntity> getSpecies() {
        return SPECIES;
    }

    @Override
    public final int getExperience() {
        return this.field_70728_aV;
    }

    @Override
    public final void setExperience(int xp) {
        this.field_70728_aV = xp;
    }

    @Override
    public void setSpecialPathfindingMalus(PathNodeType nodeType, float malus) {
        this.func_184644_a(nodeType, malus);
    }

    @Nullable
    public <T extends MobEntity> T func_233656_b_(EntityType<T> entityType, boolean keepEquipment) {
        MobEntity replacement = super.func_233656_b_(entityType, keepEquipment);
        if (replacement instanceof ISpecialMob && this.field_70170_p instanceof IServerWorld) {
            MobHelper.finalizeSpawn((LivingEntity)replacement, (IServerWorld)this.field_70170_p, this.field_70170_p.func_175649_E(this.func_233580_cy_()), SpawnReason.CONVERSION, null);
        }
        return (T)replacement;
    }

    @Nullable
    public final ILivingEntityData func_213386_a(IServerWorld world, DifficultyInstance difficulty, SpawnReason spawnReason, @Nullable ILivingEntityData groupData, @Nullable CompoundNBT eggTag) {
        return MobHelper.finalizeSpawn((LivingEntity)this, world, difficulty, spawnReason, super.func_213386_a(world, difficulty, spawnReason, groupData, eggTag));
    }

    protected final void func_180481_a(DifficultyInstance difficulty) {
        super.func_180481_a(difficulty);
    }

    @Override
    public void finalizeSpecialSpawn(IServerWorld world, DifficultyInstance difficulty, @Nullable SpawnReason spawnReason, @Nullable ILivingEntityData groupData) {
        ItemStack heldItem = this.func_184582_a(EquipmentSlotType.MAINHAND);
        if (heldItem.func_190926_b() || heldItem.func_77973_b() == Items.field_203184_eO || heldItem.func_77973_b() == Items.field_151112_aM) {
            double heldItemChoice = this.field_70146_Z.nextDouble();
            if (this.getSpecialData().getRangedAttackMaxRange() > 0.0f && heldItemChoice < this.getConfig().DROWNED.tridentEquipChance.get()) {
                this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)Items.field_203184_eO));
            } else if (heldItemChoice >= 0.9625) {
                this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)Items.field_151112_aM));
            } else {
                this.func_184201_a(EquipmentSlotType.MAINHAND, ItemStack.field_190927_a);
            }
        }
        if (this.getConfig().DROWNED.shieldEquipChance.rollChance(this.field_70146_Z)) {
            this.func_184201_a(EquipmentSlotType.OFFHAND, new ItemStack((IItemProvider)Items.field_185159_cQ));
        }
        this.finalizeVariantSpawn(world, difficulty, spawnReason, groupData);
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.getSpecialData().tick();
    }

    protected float func_213348_b(Pose pose, EntitySize size) {
        return super.func_213348_b(pose, size) * this.getSpecialData().getHeightScale();
    }

    public boolean func_230279_az_() {
        return this.getSpecialData().isImmuneToFire();
    }

    public void func_241209_g_(int ticks) {
        if (!this.getSpecialData().isImmuneToBurning()) {
            super.func_241209_g_(ticks);
        }
    }

    protected boolean func_190730_o() {
        return !this.getSpecialData().isImmuneToFire() && !this.getSpecialData().isImmuneToBurning();
    }

    public boolean func_184652_a(PlayerEntity player) {
        return !this.func_110167_bD() && this.getSpecialData().allowLeashing();
    }

    public void func_213295_a(BlockState block, Vector3d speedMulti) {
        if (this.getSpecialData().canBeStuckIn(block)) {
            super.func_213295_a(block, speedMulti);
        }
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return super.func_225503_b_(distance, damageMultiplier * this.getSpecialData().getFallDamageMultiplier());
    }

    public boolean func_145773_az() {
        return this.getSpecialData().ignorePressurePlates();
    }

    public boolean func_70648_aU() {
        return this.getSpecialData().canBreatheInWater();
    }

    public boolean func_96092_aw() {
        return !this.getSpecialData().ignoreWaterPush();
    }

    public boolean func_230270_dK_() {
        return this.getSpecialData().isDamagedByWater();
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        Entity entity = source.func_76364_f();
        if (this.func_230270_dK_() && entity instanceof SnowballEntity) {
            amount = Math.max(3.0f, amount);
        }
        if (amount > 0.0f && MobHelper.tryBlockAttack((LivingEntity)this, source, true)) {
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_70687_e(EffectInstance effect) {
        return this.getSpecialData().isPotionApplicable(effect);
    }

    public void func_213281_b(CompoundNBT tag) {
        super.func_213281_b(tag);
        CompoundNBT saveTag = SpecialMobData.getSaveLocation(tag);
        this.getSpecialData().writeToNBT(saveTag);
        this.addVariantSaveData(saveTag);
    }

    public void func_70037_a(CompoundNBT tag) {
        super.func_70037_a(tag);
        CompoundNBT saveTag = SpecialMobData.getSaveLocation(tag);
        this.getSpecialData().readFromNBT(saveTag);
        this.readVariantSaveData(saveTag);
        this.recalculateAttackGoal();
    }

    static {
        SCALE = EntityDataManager.func_187226_a(_SpecialDrownedEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    }
}

