/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.drowned;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.config.species.DrownedSpeciesConfig;
import fathertoast.specialmobs.common.config.species.SpeciesConfig;
import fathertoast.specialmobs.common.entity.MobHelper;
import fathertoast.specialmobs.common.entity.drowned._SpecialDrownedEntity;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.potion.Effects;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;

@SpecialMob
public class TropicalDrownedEntity
extends _SpecialDrownedEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<TropicalDrownedEntity> SPECIES;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(14246563).weight(BestiaryInfo.DefaultWeight.LOWEST).theme(BestiaryInfo.Theme.TROPICAL).uniqueTextureWithOverlay().addExperience(1).multiplyRangedCooldown(0.75f).rangedMaxRange(15.0).multiplyAttribute(Attributes.field_233821_d_, 1.2);
    }

    @SpecialMob.ConfigSupplier
    public static SpeciesConfig createConfig(MobFamily.Species<?> species) {
        return new DrownedSpeciesConfig(species, 1.0, 0.0625);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Tropical Drowned", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        TropicalDrownedEntity.addBaseLoot(loot);
        loot.addCommonDrop("common", (IItemProvider)Blocks.field_204913_jW);
        loot.addUncommonDrop("uncommon", new IItemProvider[]{Blocks.field_204278_jJ, Blocks.field_204743_jR, Blocks.field_203963_jE, Blocks.field_204279_jK, Blocks.field_204744_jS, Blocks.field_203964_jF, Blocks.field_204280_jL, Blocks.field_204745_jT, Blocks.field_203965_jG, Blocks.field_204281_jM, Blocks.field_204746_jU, Blocks.field_203966_jH, Blocks.field_204282_jN, Blocks.field_204747_jV, Blocks.field_203967_jI});
    }

    @SpecialMob.Factory
    public static EntityType.IFactory<TropicalDrownedEntity> getVariantFactory() {
        return TropicalDrownedEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends TropicalDrownedEntity> getSpecies() {
        return SPECIES;
    }

    public TropicalDrownedEntity(EntityType<? extends _SpecialDrownedEntity> entityType, World world) {
        super(entityType, world);
    }

    @Override
    protected void onVariantAttack(LivingEntity target) {
        MobHelper.applyEffect(target, Effects.field_76436_u);
    }
}

