/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.drowned;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.config.species.DrownedSpeciesConfig;
import fathertoast.specialmobs.common.config.species.SpeciesConfig;
import fathertoast.specialmobs.common.entity.drowned._SpecialDrownedEntity;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;

@SpecialMob
public class KnightDrownedEntity
extends _SpecialDrownedEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<KnightDrownedEntity> SPECIES;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(0xDDDDDD).addExperience(2).multiplyRangedSpread(1.2).addToAttribute(Attributes.field_233818_a_, 10.0).addToAttribute(Attributes.field_233826_i_, 10.0).addToAttribute(Attributes.field_233823_f_, 8.0).multiplyAttribute(Attributes.field_233821_d_, 0.8);
    }

    @SpecialMob.ConfigSupplier
    public static SpeciesConfig createConfig(MobFamily.Species<?> species) {
        return new DrownedSpeciesConfig(species, 0.9, 1.0);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Drowned Knight", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        KnightDrownedEntity.addBaseLoot(loot);
        loot.addCommonDrop("common", (IItemProvider)Items.field_151074_bl);
        loot.addUncommonDrop("uncommon", new IItemProvider[]{Items.field_151043_k});
    }

    @SpecialMob.Factory
    public static EntityType.IFactory<KnightDrownedEntity> getVariantFactory() {
        return KnightDrownedEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends KnightDrownedEntity> getSpecies() {
        return SPECIES;
    }

    public KnightDrownedEntity(EntityType<? extends _SpecialDrownedEntity> entityType, World world) {
        super(entityType, world);
    }

    @Override
    public void finalizeVariantSpawn(IServerWorld world, DifficultyInstance difficulty, @Nullable SpawnReason spawnReason, @Nullable ILivingEntityData groupData) {
        ItemStack heldItem = this.func_184582_a(EquipmentSlotType.MAINHAND);
        if (heldItem.func_190926_b() || heldItem.func_77973_b() == Items.field_151112_aM) {
            this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)Items.field_151010_B));
        }
        this.func_184201_a(EquipmentSlotType.HEAD, new ItemStack((IItemProvider)Items.field_151020_U));
        this.func_184201_a(EquipmentSlotType.CHEST, new ItemStack((IItemProvider)Items.field_151023_V));
        this.func_184201_a(EquipmentSlotType.LEGS, new ItemStack((IItemProvider)Items.field_151022_W));
        this.func_184201_a(EquipmentSlotType.FEET, new ItemStack((IItemProvider)Items.field_151029_X));
    }
}

