/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.drowned;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.block.MeltingIceBlock;
import fathertoast.specialmobs.common.entity.MobHelper;
import fathertoast.specialmobs.common.entity.drowned._SpecialDrownedEntity;
import fathertoast.specialmobs.common.util.ExplosionHelper;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.potion.Effects;
import net.minecraft.state.Property;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;

@SpecialMob
public class FrozenDrownedEntity
extends _SpecialDrownedEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<FrozenDrownedEntity> SPECIES;
    private static final int ICE_SEAL_TICKS = 4;
    private int iceSealTimer;
    private BlockPos iceSealPos;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(0xDDEAEA).weight(BestiaryInfo.DefaultWeight.LOW).theme(BestiaryInfo.Theme.ICE).uniqueTextureWithOverlay().addExperience(2).effectImmune(Effects.field_76421_d).addToAttribute(Attributes.field_233826_i_, 10.0).multiplyAttribute(Attributes.field_233821_d_, 0.8);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Frozen Drowned", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        FrozenDrownedEntity.addBaseLoot(loot);
        loot.addCommonDrop("common", (IItemProvider)Blocks.field_150432_aD);
        loot.addRareDrop("rare", new IItemProvider[]{Blocks.field_205164_gk});
    }

    @SpecialMob.Factory
    public static EntityType.IFactory<FrozenDrownedEntity> getVariantFactory() {
        return FrozenDrownedEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends FrozenDrownedEntity> getSpecies() {
        return SPECIES;
    }

    public FrozenDrownedEntity(EntityType<? extends _SpecialDrownedEntity> entityType, World world) {
        super(entityType, world);
    }

    @Override
    protected void onVariantAttack(LivingEntity target) {
        MobHelper.applyEffect(target, Effects.field_76421_d, 2);
    }

    @Override
    public void func_70636_d() {
        if (!this.field_70170_p.func_201670_d()) {
            BlockPos pos;
            LivingEntity target;
            if (this.iceSealPos != null) {
                if (this.iceSealTimer++ % 4 == 0) {
                    int radius = this.iceSealTimer / 4;
                    this.makeIceSeal(this.iceSealPos, radius);
                    if (radius >= 7) {
                        this.iceSealTimer = 100 + this.field_70146_Z.nextInt(100);
                        this.iceSealPos = null;
                    }
                }
            } else if (this.iceSealTimer-- <= 0 && (target = this.func_70638_az()) != null && target.func_204231_K() && this.func_70068_e((Entity)target) < 144.0 && this.field_70146_Z.nextInt(20) == 0 && (pos = this.findIceSealPos(target.func_233580_cy_(), MathHelper.func_76123_f((float)target.func_213302_cg()))) != null && ExplosionHelper.getMode((Entity)this) != Explosion.Mode.NONE) {
                this.iceSealTimer = 0;
                this.iceSealPos = pos;
            }
        }
        super.func_70636_d();
    }

    @Nullable
    private BlockPos findIceSealPos(BlockPos targetPos, int targetHeight) {
        int maxRange = 6 + targetHeight;
        BlockPos.Mutable pos = targetPos.func_239590_i_();
        for (int y = 0; y <= maxRange; ++y) {
            pos.func_185336_p(targetPos.func_177956_o() + y);
            if (pos.func_177956_o() >= this.field_70170_p.func_217301_I()) break;
            BlockState block = this.field_70170_p.func_180495_p((BlockPos)pos);
            if (block.func_177230_c() == Blocks.field_150355_j && (Integer)block.func_177229_b((Property)FlowingFluidBlock.field_176367_b) == 0) continue;
            if (y - 1 <= targetHeight) break;
            return pos.func_177977_b();
        }
        return null;
    }

    private void makeIceSeal(BlockPos center, int radius) {
        if (!this.func_174814_R()) {
            this.field_70170_p.func_184148_a(null, (double)center.func_177958_n() + 0.5, (double)center.func_177956_o() + 0.5, (double)center.func_177952_p() + 0.5, SoundEvents.field_187561_bM, this.func_184176_by(), 0.4f, 1.0f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
        }
        if (radius <= 0) {
            this.placeSealBlock(center);
            return;
        }
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                int distSq = x * x + z * z;
                if (distSq > radius * radius) continue;
                this.placeSealBlock(center.func_177982_a(x, 0, z));
            }
        }
    }

    private void placeSealBlock(BlockPos pos) {
        BlockState block = MeltingIceBlock.getState(this.field_70170_p, pos);
        if (this.field_70170_p.func_180495_p(pos).func_185904_a().func_76222_j() && this.field_70170_p.func_226663_a_(block, pos, ISelectionContext.func_216377_a()) && MobHelper.placeBlock((Entity)this, pos, block)) {
            MeltingIceBlock.scheduleFirstTick(this.field_70170_p, pos, this.field_70146_Z);
        }
    }
}

