/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.drowned;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.core.register.SMEffects;
import fathertoast.specialmobs.common.entity.MobHelper;
import fathertoast.specialmobs.common.entity.ai.AIHelper;
import fathertoast.specialmobs.common.entity.ai.goal.AmphibiousGoToWaterGoal;
import fathertoast.specialmobs.common.entity.drowned._SpecialDrownedEntity;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.item.Items;
import net.minecraft.potion.Effect;
import net.minecraft.potion.Effects;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;

@SpecialMob
public class AbyssalDrownedEntity
extends _SpecialDrownedEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<AbyssalDrownedEntity> SPECIES;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(2242628).weight(BestiaryInfo.DefaultWeight.LOW).uniqueTexturesAll().addExperience(2).effectImmune(SMEffects.WEIGHT, Effects.field_188424_y).addToAttribute(Attributes.field_233818_a_, 20.0).multiplyAttribute(Attributes.field_233821_d_, 1.2);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Abyssal Drowned", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        AbyssalDrownedEntity.addBaseLoot(loot);
        loot.addUncommonDrop("uncommon", new IItemProvider[]{Items.field_151074_bl, Items.field_179562_cC, Items.field_179563_cD});
        loot.addRareDrop("rare", new IItemProvider[]{Items.field_151043_k});
    }

    @SpecialMob.Factory
    public static EntityType.IFactory<AbyssalDrownedEntity> getVariantFactory() {
        return AbyssalDrownedEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends AbyssalDrownedEntity> getSpecies() {
        return SPECIES;
    }

    public AbyssalDrownedEntity(EntityType<? extends _SpecialDrownedEntity> entityType, World world) {
        super(entityType, world);
    }

    @Override
    protected void registerVariantGoals() {
        AIHelper.removeGoals(this.field_70714_bg, 1);
        this.field_70714_bg.func_75776_a(1, (Goal)new AmphibiousGoToWaterGoal((MobEntity)this, 1.0).alwaysEnabled());
        AIHelper.removeGoals(this.field_70714_bg, 5);
        AIHelper.removeGoals(this.field_70714_bg, 6);
    }

    @Override
    protected void onVariantAttack(LivingEntity target) {
        MobHelper.applyEffect(target, (Effect)SMEffects.WEIGHT.get(), 2);
    }
}

