/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.creeper;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.config.family.CreeperFamilyConfig;
import fathertoast.specialmobs.common.config.species.CreeperSpeciesConfig;
import fathertoast.specialmobs.common.config.species.SpeciesConfig;
import fathertoast.specialmobs.common.entity.ISpecialMob;
import fathertoast.specialmobs.common.entity.MobHelper;
import fathertoast.specialmobs.common.entity.SpecialMobData;
import fathertoast.specialmobs.common.entity.ai.IExplodingMob;
import fathertoast.specialmobs.common.event.NaturalSpawnManager;
import fathertoast.specialmobs.common.util.ExplosionHelper;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AreaEffectCloudEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.SnowballEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

@SpecialMob
public class _SpecialCreeperEntity
extends CreeperEntity
implements IExplodingMob,
ISpecialMob<_SpecialCreeperEntity> {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<_SpecialCreeperEntity> SPECIES;
    private static final DataParameter<Float> SCALE;
    private static final DataParameter<Byte> EXPLODE_FLAGS;
    private static final byte EXPLODE_FLAG_SUPERCHARGED = 1;
    private static final byte EXPLODE_FLAG_DEFUSE_IN_WATER = 2;
    private static final byte EXPLODE_FLAG_ON_FIRE = 4;
    private static final byte EXPLODE_FLAG_WHEN_SHOT = 8;
    private SpecialMobData<_SpecialCreeperEntity> specialData;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(0).vanillaTextureBaseOnly("textures/entity/creeper/creeper.png").experience(5);
    }

    @SpecialMob.ConfigSupplier
    public static SpeciesConfig createConfig(MobFamily.Species<?> species) {
        return new CreeperSpeciesConfig(species, false, false, false);
    }

    public CreeperSpeciesConfig getConfig() {
        return (CreeperSpeciesConfig)this.getSpecies().config;
    }

    @SpecialMob.AttributeSupplier
    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return CreeperEntity.func_234278_m_();
    }

    @SpecialMob.SpawnPlacementRegistrar
    public static void registerSpawnPlacement(MobFamily.Species<? extends _SpecialCreeperEntity> species) {
        NaturalSpawnManager.registerSpawnPlacement(species);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Creeper", "Creeper", "Creeper", "Creeper", "Creeper", "Creeper", "Creeper");
    }

    @SpecialMob.LootTableProvider
    public static void addBaseLoot(LootTableBuilder loot) {
        loot.addLootTable("main", EntityType.field_200797_k.func_220348_g());
    }

    @SpecialMob.Factory
    public static EntityType.IFactory<_SpecialCreeperEntity> getFactory() {
        return _SpecialCreeperEntity::new;
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.registerVariantGoals();
    }

    protected void registerVariantGoals() {
    }

    public void finalizeVariantSpawn(IServerWorld world, DifficultyInstance difficulty, @Nullable SpawnReason spawnReason, @Nullable ILivingEntityData groupData) {
    }

    public void func_174815_a(LivingEntity attacker, Entity target) {
        if (target instanceof LivingEntity) {
            this.onVariantAttack((LivingEntity)target);
        }
        super.func_174815_a(attacker, target);
    }

    protected void onVariantAttack(LivingEntity target) {
    }

    protected void func_146077_cc() {
        if (!this.field_70170_p.field_72995_K) {
            this.field_70729_aU = true;
            this.makeVariantExplosion(this.getVariantExplosionPower(this.field_82226_g));
            this.func_70106_y();
            this.func_190741_do();
        }
    }

    protected float getVariantExplosionPower(float radius) {
        return radius * (this.isSupercharged() ? 3.5f : (this.func_225509_J__() ? 2.0f : 1.0f));
    }

    protected void makeVariantExplosion(float explosionPower) {
        ExplosionHelper.explode((Entity)this, explosionPower, true, false);
    }

    protected void func_190741_do() {
        ArrayList<EffectInstance> effects = new ArrayList<EffectInstance>(this.func_70651_bq());
        this.modifyVariantLingeringCloudEffects(effects);
        if (!effects.isEmpty()) {
            AreaEffectCloudEntity potionCloud = new AreaEffectCloudEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
            potionCloud.func_184483_a(this.getVariantExplosionPower((float)this.field_82226_g - 0.5f));
            potionCloud.func_184495_b(-0.5f);
            potionCloud.func_184485_d(10);
            potionCloud.func_184486_b(potionCloud.func_184489_o() / 2);
            potionCloud.func_184487_c(-potionCloud.func_184490_j() / (float)potionCloud.func_184489_o());
            for (EffectInstance effect : effects) {
                potionCloud.func_184496_a(new EffectInstance(effect));
            }
            this.modifyVariantLingeringCloud(potionCloud);
            this.field_70170_p.func_217376_c((Entity)potionCloud);
        }
    }

    protected void modifyVariantLingeringCloudEffects(List<EffectInstance> potions) {
    }

    protected void modifyVariantLingeringCloud(AreaEffectCloudEntity potionCloud) {
    }

    public void addVariantSaveData(CompoundNBT saveTag) {
    }

    public void readVariantSaveData(CompoundNBT saveTag) {
    }

    public _SpecialCreeperEntity(EntityType<? extends _SpecialCreeperEntity> entityType, World world) {
        super(entityType, world);
        this.setCannotExplodeWhileWet(!this.getConfig().CREEPERS.canExplodeWhileWet.get());
        this.setExplodesWhileBurning(this.getConfig().CREEPERS.explodesWhileBurning.get());
        this.setExplodesWhenShot(this.getConfig().CREEPERS.explodesWhenShot.get());
        this.getSpecialData().initialize();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.specialData = new SpecialMobData<_SpecialCreeperEntity>(this, SCALE);
        this.field_70180_af.func_187214_a(EXPLODE_FLAGS, (Object)0);
    }

    public void func_70071_h_() {
        if (this.func_70089_S()) {
            if (this.func_203008_ap() && this.cannotExplodeWhileWet()) {
                if (this.func_146078_ca()) {
                    this.field_70180_af.func_187227_b(field_184715_c, (Object)false);
                }
                this.func_70829_a(-1);
            } else if (this.func_70027_ad() && this.explodesWhileBurning()) {
                this.func_70829_a(1);
            }
        }
        super.func_70071_h_();
    }

    public void func_241841_a(ServerWorld world, LightningBoltEntity lightningBolt) {
        this.charge();
        super.func_241841_a(world, lightningBolt);
        if (this.explodesWhileBurning()) {
            this.func_70066_B();
        }
    }

    public void charge() {
        if (!this.func_225509_J__()) {
            this.setPowered(true);
            if (((CreeperFamilyConfig)MobFamily.CREEPER.config).CREEPERS.superchargeChance.rollChance(this.field_70146_Z)) {
                this.setSupercharged(true);
            }
        }
    }

    public void copyChargedState(_SpecialCreeperEntity other) {
        this.setPowered(other.func_225509_J__());
        this.setSupercharged(other.isSupercharged());
    }

    private void setPowered(boolean charged) {
        this.field_70180_af.func_187227_b(field_184714_b, (Object)charged);
    }

    public boolean isSupercharged() {
        return this.getExplodeFlag((byte)1);
    }

    private void setSupercharged(boolean value) {
        if (value && !this.func_225509_J__()) {
            this.setPowered(true);
        }
        this.setExplodeFlag((byte)1, value);
    }

    public boolean cannotExplodeWhileWet() {
        return this.getExplodeFlag((byte)2);
    }

    private void setCannotExplodeWhileWet(boolean value) {
        this.setExplodeFlag((byte)2, value);
        this.func_184644_a(PathNodeType.WATER, value ? PathNodeType.LAVA.func_186289_a() : PathNodeType.WATER.func_186289_a());
    }

    public boolean explodesWhileBurning() {
        return this.getExplodeFlag((byte)4);
    }

    private void setExplodesWhileBurning(boolean value) {
        this.setExplodeFlag((byte)4, value);
        if (value) {
            this.func_184644_a(PathNodeType.DANGER_FIRE, PathNodeType.DAMAGE_FIRE.func_186289_a());
            this.func_184644_a(PathNodeType.DAMAGE_FIRE, PathNodeType.BLOCKED.func_186289_a());
        } else {
            this.func_184644_a(PathNodeType.DANGER_FIRE, PathNodeType.DANGER_FIRE.func_186289_a());
            this.func_184644_a(PathNodeType.DAMAGE_FIRE, PathNodeType.DAMAGE_FIRE.func_186289_a());
        }
    }

    public boolean explodesWhenShot() {
        return this.getExplodeFlag((byte)8);
    }

    private void setExplodesWhenShot(boolean value) {
        this.setExplodeFlag((byte)8, value);
    }

    private boolean getExplodeFlag(byte flag) {
        return ((Byte)this.field_70180_af.func_187225_a(EXPLODE_FLAGS) & flag) != 0;
    }

    private void setExplodeFlag(byte flag, boolean value) {
        byte allFlags = (Byte)this.field_70180_af.func_187225_a(EXPLODE_FLAGS);
        if (value == ((allFlags & flag) == 0)) {
            this.field_70180_af.func_187227_b(EXPLODE_FLAGS, (Object)((byte)(allFlags ^ flag)));
        }
    }

    @Override
    public SpecialMobData<_SpecialCreeperEntity> getSpecialData() {
        return this.specialData;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends _SpecialCreeperEntity> getSpecies() {
        return SPECIES;
    }

    @Override
    public final int getExperience() {
        return this.field_70728_aV;
    }

    @Override
    public final void setExperience(int xp) {
        this.field_70728_aV = xp;
    }

    @Override
    public void setSpecialPathfindingMalus(PathNodeType nodeType, float malus) {
        this.func_184644_a(nodeType, malus);
    }

    @Nullable
    public <T extends MobEntity> T func_233656_b_(EntityType<T> entityType, boolean keepEquipment) {
        MobEntity replacement = super.func_233656_b_(entityType, keepEquipment);
        if (replacement instanceof ISpecialMob && this.field_70170_p instanceof IServerWorld) {
            MobHelper.finalizeSpawn((LivingEntity)replacement, (IServerWorld)this.field_70170_p, this.field_70170_p.func_175649_E(this.func_233580_cy_()), SpawnReason.CONVERSION, null);
        }
        return (T)replacement;
    }

    @Nullable
    public final ILivingEntityData func_213386_a(IServerWorld world, DifficultyInstance difficulty, SpawnReason spawnReason, @Nullable ILivingEntityData groupData, @Nullable CompoundNBT eggTag) {
        return MobHelper.finalizeSpawn((LivingEntity)this, world, difficulty, spawnReason, super.func_213386_a(world, difficulty, spawnReason, groupData, eggTag));
    }

    protected final void func_180481_a(DifficultyInstance difficulty) {
        super.func_180481_a(difficulty);
    }

    @Override
    public void finalizeSpecialSpawn(IServerWorld world, DifficultyInstance difficulty, @Nullable SpawnReason spawnReason, @Nullable ILivingEntityData groupData) {
        if (world.func_72912_H().func_76061_m()) {
            double chargedChance;
            double d = chargedChance = this.getConfig().CREEPERS.stormChargeChance.get() < 0.0 ? ((CreeperFamilyConfig)MobFamily.CREEPER.config).CREEPERS.familyStormChargeChance.get() : this.getConfig().CREEPERS.stormChargeChance.get();
            if (this.field_70146_Z.nextDouble() < chargedChance) {
                this.charge();
            }
        }
        this.finalizeVariantSpawn(world, difficulty, spawnReason, groupData);
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.getSpecialData().tick();
    }

    public boolean func_230279_az_() {
        return this.getSpecialData().isImmuneToFire();
    }

    public void func_241209_g_(int ticks) {
        if (!this.getSpecialData().isImmuneToBurning()) {
            super.func_241209_g_(ticks);
        }
    }

    public boolean func_184652_a(PlayerEntity player) {
        return !this.func_110167_bD() && this.getSpecialData().allowLeashing();
    }

    public void func_213295_a(BlockState block, Vector3d speedMulti) {
        if (this.getSpecialData().canBeStuckIn(block)) {
            super.func_213295_a(block, speedMulti);
        }
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return super.func_225503_b_(distance, damageMultiplier * this.getSpecialData().getFallDamageMultiplier());
    }

    public boolean func_145773_az() {
        return this.getSpecialData().ignorePressurePlates();
    }

    public boolean func_70648_aU() {
        return this.getSpecialData().canBreatheInWater();
    }

    public boolean func_96092_aw() {
        return !this.getSpecialData().ignoreWaterPush();
    }

    public boolean func_230270_dK_() {
        return this.getSpecialData().isDamagedByWater();
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_230270_dK_() && source.func_76364_f() instanceof SnowballEntity) {
            amount = Math.max(3.0f, amount);
        }
        if (super.func_70097_a(source, amount)) {
            if (source.func_76364_f() != source.func_76346_g() && this.explodesWhenShot()) {
                this.func_146079_cb();
            }
            return true;
        }
        return false;
    }

    public boolean func_70687_e(EffectInstance effect) {
        return this.getSpecialData().isPotionApplicable(effect);
    }

    public void func_213281_b(CompoundNBT tag) {
        super.func_213281_b(tag);
        CompoundNBT saveTag = SpecialMobData.getSaveLocation(tag);
        saveTag.func_74757_a("Supercharged", this.isSupercharged());
        saveTag.func_74757_a("CannotExplodeWhileWet", this.cannotExplodeWhileWet());
        saveTag.func_74757_a("ExplodesWhileBurning", this.explodesWhileBurning());
        saveTag.func_74757_a("ExplodesWhenShot", this.explodesWhenShot());
        this.getSpecialData().writeToNBT(saveTag);
        this.addVariantSaveData(saveTag);
    }

    public void func_70037_a(CompoundNBT tag) {
        super.func_70037_a(tag);
        CompoundNBT saveTag = SpecialMobData.getSaveLocation(tag);
        if (saveTag.func_150297_b("Supercharged", 99)) {
            this.setSupercharged(saveTag.func_74767_n("Supercharged"));
        }
        if (saveTag.func_150297_b("CannotExplodeWhileWet", 99)) {
            this.setCannotExplodeWhileWet(saveTag.func_74767_n("CannotExplodeWhileWet"));
        }
        if (saveTag.func_150297_b("ExplodesWhileBurning", 99)) {
            this.setExplodesWhileBurning(saveTag.func_74767_n("ExplodesWhileBurning"));
        }
        if (saveTag.func_150297_b("ExplodesWhenShot", 99)) {
            this.setExplodesWhenShot(saveTag.func_74767_n("ExplodesWhenShot"));
        }
        this.getSpecialData().readFromNBT(saveTag);
        this.readVariantSaveData(saveTag);
    }

    static {
        SCALE = EntityDataManager.func_187226_a(_SpecialCreeperEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
        EXPLODE_FLAGS = EntityDataManager.func_187226_a(_SpecialCreeperEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    }
}

