/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.creeper;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.config.species.SpeciesConfig;
import fathertoast.specialmobs.common.config.species.SplittingCreeperSpeciesConfig;
import fathertoast.specialmobs.common.entity.creeper.MiniCreeperEntity;
import fathertoast.specialmobs.common.entity.creeper._SpecialCreeperEntity;
import fathertoast.specialmobs.common.util.ExplosionHelper;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;

@SpecialMob
public class SplittingCreeperEntity
extends _SpecialCreeperEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<SplittingCreeperEntity> SPECIES;
    private int extraBabies;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(6266146).weight(BestiaryInfo.DefaultWeight.LOW).uniqueTextureWithEyes().size(1.2f, 0.7f, 1.99f).addExperience(2).addToAttribute(Attributes.field_233818_a_, 20.0);
    }

    @SpecialMob.ConfigSupplier
    public static SpeciesConfig createConfig(MobFamily.Species<?> species) {
        return new SplittingCreeperSpeciesConfig(species, false, false, true, 1, 3);
    }

    @Override
    public SplittingCreeperSpeciesConfig getConfig() {
        return (SplittingCreeperSpeciesConfig)this.getSpecies().config;
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Splitting Creeper", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        SplittingCreeperEntity.addBaseLoot(loot);
        loot.addUncommonDrop("uncommon", new IItemProvider[]{Items.field_196167_cx});
    }

    @SpecialMob.Factory
    public static EntityType.IFactory<SplittingCreeperEntity> getVariantFactory() {
        return SplittingCreeperEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends SplittingCreeperEntity> getSpecies() {
        return SPECIES;
    }

    public SplittingCreeperEntity(EntityType<? extends _SpecialCreeperEntity> entityType, World world) {
        super(entityType, world);
        this.extraBabies = this.getConfig().SPLITTING.extraBabies.next(this.field_70146_Z);
    }

    @Override
    protected void makeVariantExplosion(float explosionPower) {
        ExplosionHelper.explode((Entity)this, explosionPower, false, false);
        if (!(this.field_70170_p instanceof IServerWorld)) {
            return;
        }
        int babiesToSpawn = this.extraBabies + (int)(explosionPower * explosionPower) / 2;
        ILivingEntityData groupData = null;
        for (int i = 0; i < babiesToSpawn; ++i) {
            groupData = this.spawnBaby(explosionPower / 3.0f, groupData);
        }
        this.func_70656_aK();
        this.func_184185_a(SoundEvents.field_187511_aA, 1.0f, 2.0f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
    }

    @Nullable
    private ILivingEntityData spawnBaby(float speed, @Nullable ILivingEntityData groupData) {
        MiniCreeperEntity baby = (MiniCreeperEntity)((EntityType)MiniCreeperEntity.SPECIES.entityType.get()).func_200721_a(this.field_70170_p);
        if (baby == null) {
            return groupData;
        }
        baby.func_82149_j((Entity)this);
        baby.field_70759_as = this.field_70177_z;
        baby.field_70761_aq = this.field_70177_z;
        groupData = baby.func_213386_a((IServerWorld)this.field_70170_p, this.field_70170_p.func_175649_E(this.func_233580_cy_()), SpawnReason.MOB_SUMMONED, groupData, null);
        baby.copyChargedState(this);
        baby.func_70624_b(this.func_70638_az());
        baby.func_213293_j((this.field_70146_Z.nextDouble() - 0.5) * (double)speed, 0.3 + 0.3 * this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * (double)speed);
        baby.func_230245_c_(false);
        this.field_70170_p.func_217376_c((Entity)baby);
        return groupData;
    }

    @Override
    public void addVariantSaveData(CompoundNBT saveTag) {
        saveTag.func_74774_a("ExtraBabies", (byte)this.extraBabies);
    }

    @Override
    public void readVariantSaveData(CompoundNBT saveTag) {
        if (saveTag.func_150297_b("ExtraBabies", 99)) {
            this.extraBabies = saveTag.func_74771_c("ExtraBabies");
        }
    }
}

