/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.creeper;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.block.MeltingIceBlock;
import fathertoast.specialmobs.common.config.species.SnowCreeperSpeciesConfig;
import fathertoast.specialmobs.common.config.species.SpeciesConfig;
import fathertoast.specialmobs.common.entity.MobHelper;
import fathertoast.specialmobs.common.entity.ai.AIHelper;
import fathertoast.specialmobs.common.entity.ai.FluidPathNavigator;
import fathertoast.specialmobs.common.entity.creeper._SpecialCreeperEntity;
import fathertoast.specialmobs.common.entity.skeleton.StraySkeletonEntity;
import fathertoast.specialmobs.common.util.ExplosionHelper;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.Effects;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.Explosion;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;

@SpecialMob
public class SnowCreeperEntity
extends _SpecialCreeperEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<SnowCreeperEntity> SPECIES;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(0xE8F8F8).weight(BestiaryInfo.DefaultWeight.LOW).theme(BestiaryInfo.Theme.ICE).uniqueTextureWithEyes().addExperience(2).effectImmune(Effects.field_76421_d).addToAttribute(Attributes.field_233818_a_, 10.0);
    }

    @SpecialMob.ConfigSupplier
    public static SpeciesConfig createConfig(MobFamily.Species<?> species) {
        return new SnowCreeperSpeciesConfig(species, false, false, false, 0.33);
    }

    @Override
    public SnowCreeperSpeciesConfig getConfig() {
        return (SnowCreeperSpeciesConfig)this.getSpecies().config;
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Snow Creeper", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        SnowCreeperEntity.addBaseLoot(loot);
        loot.addClusterDrop("common", (IItemProvider)Items.field_151126_ay);
        loot.addUncommonDrop("uncommon", new IItemProvider[]{Blocks.field_150403_cj});
        loot.addRareDrop("rare", new IItemProvider[]{Blocks.field_205164_gk});
    }

    @SpecialMob.Factory
    public static EntityType.IFactory<SnowCreeperEntity> getVariantFactory() {
        return SnowCreeperEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends SnowCreeperEntity> getSpecies() {
        return SPECIES;
    }

    public SnowCreeperEntity(EntityType<? extends _SpecialCreeperEntity> entityType, World world) {
        super(entityType, world);
        this.func_184644_a(PathNodeType.WATER, PathNodeType.WALKABLE.func_186289_a());
    }

    @Override
    protected void registerVariantGoals() {
        AIHelper.replaceWaterAvoidingRandomWalking((CreatureEntity)this, 0.8);
    }

    protected PathNavigator func_175447_b(World world) {
        return new FluidPathNavigator((MobEntity)this, world, true, false);
    }

    public boolean func_230285_a_(Fluid fluid) {
        return fluid.func_207185_a((ITag)FluidTags.field_206959_a);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        MobHelper.floatInFluid((Entity)this, 0.06, (ITag<Fluid>)FluidTags.field_206959_a);
        MobHelper.hopOnFluid((Entity)this);
    }

    protected void func_184594_b(BlockPos pos) {
        super.func_184594_b(pos);
        MobHelper.updateFrostWalker((LivingEntity)this, pos);
    }

    @Override
    protected float getVariantExplosionPower(float radius) {
        return super.getVariantExplosionPower(radius) + 3.0f;
    }

    @Override
    protected void makeVariantExplosion(float explosionPower) {
        Explosion.Mode explosionMode = ExplosionHelper.getMode((Entity)this);
        ExplosionHelper explosion = new ExplosionHelper((Entity)this, explosionMode == Explosion.Mode.NONE ? explosionPower : 2.0f, false, false);
        if (!explosion.initializeExplosion()) {
            return;
        }
        explosion.finalizeExplosion();
        int radius = (int)Math.floor(explosionPower);
        BlockPos center = new BlockPos(explosion.getPos());
        if (explosionMode != Explosion.Mode.NONE) {
            boolean snowGlobe = this.func_204231_K() || this.field_70146_Z.nextDouble() < this.getConfig().SNOW.snowGlobeChance.get();
            int radiusSq = radius * radius;
            int rMinusOneSq = (radius - 1) * (radius - 1);
            for (int y = -radius; y <= radius; ++y) {
                for (int x = -radius; x <= radius; ++x) {
                    for (int z = -radius; z <= radius; ++z) {
                        BlockState blockAbove;
                        int distSq = x * x + y * y + z * z;
                        if (distSq > radiusSq) continue;
                        BlockPos pos = center.func_177982_a(x, y, z);
                        BlockState block = this.field_70170_p.func_180495_p(pos);
                        if ((block.func_203425_a(Blocks.field_185778_de) || block.func_177230_c() == Blocks.field_150355_j && (Integer)block.func_177229_b((Property)FlowingFluidBlock.field_176367_b) == 0) && !(blockAbove = this.field_70170_p.func_180495_p(pos.func_177984_a())).func_185904_a().func_76230_c() && !blockAbove.func_204520_s().func_206884_a((ITag)FluidTags.field_206959_a) && MobHelper.placeBlock((Entity)this, pos, MeltingIceBlock.getState(this.field_70170_p, pos))) {
                            MeltingIceBlock.scheduleFirstTick(this.field_70170_p, pos, this.field_70146_Z);
                        }
                        if (distSq <= rMinusOneSq) continue;
                        if (snowGlobe) {
                            if (!this.field_70170_p.func_180495_p(pos).func_185904_a().func_76222_j() || !MobHelper.placeBlock((Entity)this, pos, MeltingIceBlock.getState(this.field_70170_p, pos))) continue;
                            MeltingIceBlock.scheduleFirstTick(this.field_70170_p, pos, this.field_70146_Z);
                            continue;
                        }
                        if (y != 0) continue;
                        this.placePillar(pos, radius);
                    }
                }
            }
        }
        int strays = radius / 2;
        for (int count = 0; count < strays; ++count) {
            for (int attempt = 0; attempt < 8 && !this.trySpawnStray(center, radius); ++attempt) {
            }
        }
    }

    private void placePillar(BlockPos pos, int radius) {
        BlockPos.Mutable currentPos = pos.func_239590_i_();
        if (this.shouldReplace((BlockPos)currentPos)) {
            this.findGroundBelow(currentPos, radius);
        } else if (this.findGroundAbove(currentPos, radius)) {
            return;
        }
        int maxY = Math.min(currentPos.func_177956_o() + 4, this.field_70170_p.func_217301_I() - 2);
        int height = -2;
        if (pos.func_177956_o() > currentPos.func_177956_o()) {
            height -= (pos.func_177956_o() - currentPos.func_177956_o()) / 2;
        }
        while (currentPos.func_177956_o() < maxY && this.shouldReplace((BlockPos)currentPos)) {
            if (MobHelper.placeBlock((Entity)this, (BlockPos)currentPos, MeltingIceBlock.getState(this.field_70170_p, (BlockPos)currentPos))) {
                MeltingIceBlock.scheduleFirstTick(this.field_70170_p, (BlockPos)currentPos, this.field_70146_Z);
            }
            currentPos.func_196234_d(0, 1, 0);
            if (++height < 0 || !this.field_70146_Z.nextBoolean()) continue;
            break;
        }
    }

    private void findGroundBelow(BlockPos.Mutable currentPos, int radius) {
        int yI = currentPos.func_177956_o();
        int minY = Math.max(yI - radius, 0);
        while (currentPos.func_177956_o() > minY) {
            currentPos.func_196234_d(0, -1, 0);
            if (this.shouldReplace((BlockPos)currentPos)) continue;
            currentPos.func_196234_d(0, 1, 0);
            return;
        }
        currentPos.func_185336_p(yI);
    }

    private boolean findGroundAbove(BlockPos.Mutable currentPos, int radius) {
        int yI = currentPos.func_177956_o();
        int maxY = Math.min(yI + radius, this.field_70170_p.func_217301_I() - 2);
        while (currentPos.func_177956_o() < maxY) {
            currentPos.func_196234_d(0, 1, 0);
            if (!this.shouldReplace((BlockPos)currentPos)) continue;
            return false;
        }
        return true;
    }

    private boolean shouldReplace(BlockPos pos) {
        BlockState stateAtPos = this.field_70170_p.func_180495_p(pos);
        return (stateAtPos.func_185904_a().func_76222_j() || stateAtPos.func_235714_a_((ITag)BlockTags.field_206952_E)) && !stateAtPos.func_204520_s().func_206884_a((ITag)FluidTags.field_206959_a);
    }

    private boolean trySpawnStray(BlockPos center, int radius) {
        if (!(this.field_70170_p instanceof IServerWorld)) {
            return false;
        }
        StraySkeletonEntity stray = (StraySkeletonEntity)((EntityType)StraySkeletonEntity.SPECIES.entityType.get()).func_200721_a(this.field_70170_p);
        if (stray == null) {
            return false;
        }
        float angle = this.field_70146_Z.nextFloat() * 2.0f * (float)Math.PI;
        float distance = this.field_70146_Z.nextFloat() * (float)(radius - 1);
        BlockPos.Mutable currentPos = center.func_239590_i_().func_196234_d(MathHelper.func_76141_d((float)(MathHelper.func_76134_b((float)angle) * distance)), 0, MathHelper.func_76141_d((float)(MathHelper.func_76126_a((float)angle) * distance)));
        if (this.shouldReplace((BlockPos)currentPos)) {
            this.findGroundBelow(currentPos, radius);
        } else if (this.findGroundAbove(currentPos, radius)) {
            stray.func_70106_y();
            return false;
        }
        stray.func_174828_a((BlockPos)currentPos, angle * 180.0f / (float)Math.PI + 180.0f, 0.0f);
        while (!this.field_70170_p.func_226664_a_(stray.func_174813_aQ())) {
            if (currentPos.func_177956_o() > center.func_177956_o() + radius) {
                stray.func_70106_y();
                return false;
            }
            currentPos.func_196234_d(0, 1, 0);
            stray.func_174828_a((BlockPos)currentPos, stray.field_70177_z, stray.field_70125_A);
        }
        stray.func_70624_b(this.func_70638_az());
        stray.func_213386_a((IServerWorld)this.field_70170_p, this.field_70170_p.func_175649_E(this.func_233580_cy_()), SpawnReason.MOB_SUMMONED, null, null);
        this.field_70170_p.func_217376_c((Entity)stray);
        stray.func_70656_aK();
        return true;
    }

    @Override
    public void readVariantSaveData(CompoundNBT saveTag) {
        this.func_184644_a(PathNodeType.WATER, PathNodeType.WALKABLE.func_186289_a());
    }
}

