/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.creeper;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.entity.ai.AIHelper;
import fathertoast.specialmobs.common.entity.creeper._SpecialCreeperEntity;
import fathertoast.specialmobs.common.entity.projectile.BoneShrapnelEntity;
import fathertoast.specialmobs.common.util.ExplosionHelper;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.FleeSunGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.RestrictSunGoal;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

@SpecialMob
public class SkeletonCreeperEntity
extends _SpecialCreeperEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<SkeletonCreeperEntity> SPECIES;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(0xC1C1C1).theme(BestiaryInfo.Theme.FOREST).uniqueTextureBaseOnly().addExperience(1).undead().addToAttribute(Attributes.field_233818_a_, -4.0).multiplyAttribute(Attributes.field_233821_d_, 1.2);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Skeleton Creeper", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        SkeletonCreeperEntity.addBaseLoot(loot);
        loot.addLootTable("common", EntityType.field_200741_ag.func_220348_g());
    }

    @SpecialMob.Factory
    public static EntityType.IFactory<SkeletonCreeperEntity> getVariantFactory() {
        return SkeletonCreeperEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends SkeletonCreeperEntity> getSpecies() {
        return SPECIES;
    }

    public SkeletonCreeperEntity(EntityType<? extends _SpecialCreeperEntity> entityType, World world) {
        super(entityType, world);
    }

    @Override
    protected void registerVariantGoals() {
        AIHelper.insertGoal(this.field_70714_bg, 3, (Goal)new FleeSunGoal((CreatureEntity)this, 1.0));
        AIHelper.insertGoal(this.field_70714_bg, 3, (Goal)new RestrictSunGoal((CreatureEntity)this));
    }

    @Override
    protected float getVariantExplosionPower(float radius) {
        return super.getVariantExplosionPower(radius / 2.0f);
    }

    @Override
    protected void makeVariantExplosion(float explosionPower) {
        ExplosionHelper.explode((Entity)this, explosionPower, true, false);
        if (this.field_70170_p.func_201670_d()) {
            return;
        }
        float shootPower = explosionPower * 2.0f + 4.0f;
        int count = (int)Math.ceil(shootPower * shootPower * 3.5f);
        for (int i = 0; i < count; ++i) {
            BoneShrapnelEntity shrapnel = this.makeShrapnel(shootPower);
            float speed = (0.7f + this.field_70146_Z.nextFloat()) * shootPower / 20.0f;
            float pitch = this.field_70146_Z.nextFloat() * (float)Math.PI;
            float yaw = this.field_70146_Z.nextFloat() * 2.0f * (float)Math.PI;
            Vector3d velocity = new Vector3d((double)(MathHelper.func_76134_b((float)yaw) * speed), (double)(MathHelper.func_76126_a((float)pitch) * (shootPower + this.field_70146_Z.nextFloat() * shootPower) / 18.0f), (double)(MathHelper.func_76126_a((float)yaw) * speed));
            shrapnel.func_70186_c(velocity.field_72450_a, velocity.field_72448_b, velocity.field_72449_c, (float)velocity.func_72433_c(), 0.0f);
            shrapnel.field_70252_j = (int)((float)shrapnel.field_70252_j + pitch * 6.0f);
            this.field_70170_p.func_217376_c((Entity)shrapnel);
        }
        this.func_70656_aK();
        this.func_184185_a(SoundEvents.field_187856_fd, 1.0f, 1.0f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
    }

    private BoneShrapnelEntity makeShrapnel(float damage) {
        BoneShrapnelEntity shrapnel = new BoneShrapnelEntity((LivingEntity)this);
        shrapnel.func_190547_a((LivingEntity)this, damage);
        if (this.func_70027_ad()) {
            shrapnel.func_70015_d(100);
        }
        byte pierce = 1;
        if (this.func_225509_J__()) {
            shrapnel.func_70243_d(true);
            pierce = (byte)(pierce + 1);
        }
        if (this.isSupercharged()) {
            shrapnel.func_70240_a(shrapnel.field_70256_ap + 2);
            pierce = (byte)(pierce + 1);
        }
        shrapnel.func_213872_b(pierce);
        return shrapnel;
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223223_b_;
    }

    @Override
    public void func_70636_d() {
        if (this.func_204609_dp()) {
            ItemStack hat = this.func_184582_a(EquipmentSlotType.HEAD);
            if (!hat.func_190926_b()) {
                if (hat.func_77984_f()) {
                    hat.func_196085_b(hat.func_77952_i() + this.field_70146_Z.nextInt(2));
                    if (hat.func_77952_i() >= hat.func_77958_k()) {
                        this.func_213361_c(EquipmentSlotType.HEAD);
                        this.func_184201_a(EquipmentSlotType.HEAD, ItemStack.field_190927_a);
                    }
                }
            } else {
                this.func_70015_d(8);
            }
        }
        super.func_70636_d();
    }
}

