/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.creeper;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.entity.creeper._SpecialCreeperEntity;
import fathertoast.specialmobs.common.util.ExplosionHelper;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.block.material.Material;
import net.minecraft.entity.AreaEffectCloudEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.Items;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.storage.IServerWorldInfo;

@SpecialMob
public class SandCreeperEntity
extends _SpecialCreeperEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<SandCreeperEntity> SPECIES;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(15130028).theme(BestiaryInfo.Theme.DESERT).uniqueTextureBaseOnly().addExperience(1).addToAttribute(Attributes.field_233826_i_, 2.0).multiplyAttribute(Attributes.field_233821_d_, 1.2);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Sand Creeper", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        SandCreeperEntity.addBaseLoot(loot);
        loot.addClusterDrop("common", (IItemProvider)Blocks.field_150354_m);
        loot.addUncommonDrop("uncommon", new IItemProvider[]{Blocks.field_196583_aj});
        loot.addRareDrop("rare", new IItemProvider[]{Items.field_151043_k});
    }

    @SpecialMob.Factory
    public static EntityType.IFactory<SandCreeperEntity> getVariantFactory() {
        return SandCreeperEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends SandCreeperEntity> getSpecies() {
        return SPECIES;
    }

    public SandCreeperEntity(EntityType<? extends _SpecialCreeperEntity> entityType, World world) {
        super(entityType, world);
    }

    @Override
    protected void makeVariantExplosion(float explosionPower) {
        ExplosionHelper explosion;
        Explosion.Mode explosionMode = ExplosionHelper.getMode((Entity)this);
        if (explosionMode != Explosion.Mode.NONE) {
            int radius = (int)Math.floor(explosionPower) + 2;
            BlockPos center = new BlockPos(this.func_213303_ch());
            for (int y = -radius; y <= radius; ++y) {
                for (int x = -radius; x <= radius; ++x) {
                    for (int z = -radius; z <= radius; ++z) {
                        if (x * x + y * y + z * z > radius * radius) continue;
                        this.clearWater(center.func_177982_a(x, y, z));
                    }
                }
            }
        }
        if (!(explosion = new ExplosionHelper((Entity)this, explosionPower, explosionMode, false)).initializeExplosion()) {
            return;
        }
        explosion.finalizeExplosion();
        if (this.func_225509_J__() && this.field_70170_p.func_72912_H() instanceof IServerWorldInfo) {
            IServerWorldInfo serverInfo = (IServerWorldInfo)this.field_70170_p.func_72912_H();
            serverInfo.func_230391_a_(this.field_70146_Z.nextInt(12000) + 3600);
            serverInfo.func_76080_g(0);
            serverInfo.func_76084_b(false);
            serverInfo.func_76090_f(0);
            serverInfo.func_76069_a(false);
        }
    }

    private void clearWater(BlockPos pos) {
        if (!this.field_70170_p.func_204610_c(pos).func_206884_a((ITag)FluidTags.field_206959_a)) {
            return;
        }
        BlockState block = this.field_70170_p.func_180495_p(pos);
        if (block.func_177230_c() instanceof IBucketPickupHandler && ((IBucketPickupHandler)block.func_177230_c()).func_204508_a((IWorld)this.field_70170_p, pos, block) != Fluids.field_204541_a) {
            return;
        }
        if (block.func_177230_c() instanceof FlowingFluidBlock) {
            this.field_70170_p.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
            return;
        }
        Material material = block.func_185904_a();
        if (material == Material.field_203243_f || material == Material.field_204868_h) {
            TileEntity tileEntity = block.hasTileEntity() ? this.field_70170_p.func_175625_s(pos) : null;
            Block.func_220059_a((BlockState)block, (IWorld)this.field_70170_p, (BlockPos)pos, (TileEntity)tileEntity);
            this.field_70170_p.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
        }
    }

    @Override
    protected void modifyVariantLingeringCloudEffects(List<EffectInstance> potions) {
        potions.add(new EffectInstance(Effects.field_76438_s, 600));
    }

    @Override
    protected void modifyVariantLingeringCloud(AreaEffectCloudEntity potionCloud) {
        int duration = 40;
        float minRadius = 0.5f;
        float maxRadius = (this.getVariantExplosionPower(this.field_82226_g) + 1.0f) * 3.0f;
        potionCloud.func_184486_b(40);
        potionCloud.func_184483_a(0.5f);
        potionCloud.func_184487_c((maxRadius - 0.5f) / 40.0f);
        potionCloud.func_184495_b(0.0f);
    }
}

