/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.creeper;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.entity.creeper._SpecialCreeperEntity;
import fathertoast.specialmobs.common.util.ExplosionHelper;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;
import net.minecraft.world.storage.IServerWorldInfo;

@SpecialMob
public class LightningCreeperEntity
extends _SpecialCreeperEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<LightningCreeperEntity> SPECIES;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(4824238).theme(BestiaryInfo.Theme.STORM).uniqueTextureBaseOnly().addExperience(1).fireImmune();
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Lightning Creeper", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        LightningCreeperEntity.addBaseLoot(loot);
        loot.addCommonDrop("common", (IItemProvider)Items.field_151137_ax);
    }

    @SpecialMob.Factory
    public static EntityType.IFactory<LightningCreeperEntity> getVariantFactory() {
        return LightningCreeperEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends LightningCreeperEntity> getSpecies() {
        return SPECIES;
    }

    public LightningCreeperEntity(EntityType<? extends _SpecialCreeperEntity> entityType, World world) {
        super(entityType, world);
    }

    @Override
    protected float getVariantExplosionPower(float radius) {
        return this.isSupercharged() || this.func_225509_J__() ? super.getVariantExplosionPower(radius) : radius / 3.0f;
    }

    @Override
    protected void makeVariantExplosion(float explosionPower) {
        super.makeVariantExplosion(explosionPower);
        if (!this.field_70170_p.func_201670_d()) {
            ExplosionHelper.spawnLightning(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
            if (explosionPower >= 2.0f) {
                int radius = (int)Math.floor(explosionPower);
                for (int x = -radius; x <= radius; ++x) {
                    for (int z = -radius; z <= radius; ++z) {
                        if (x == 0 && z == 0 || x * x + z * z > radius * radius || !(this.field_70146_Z.nextFloat() < 0.3f)) continue;
                        ExplosionHelper.spawnLightning(this.field_70170_p, this.func_226277_ct_() + (double)x, this.func_226278_cu_(), this.func_226281_cx_() + (double)z);
                    }
                }
            }
        }
        if (this.func_225509_J__() && this.field_70170_p.func_72912_H() instanceof IServerWorldInfo) {
            IServerWorldInfo serverInfo = (IServerWorldInfo)this.field_70170_p.func_72912_H();
            int duration = this.field_70146_Z.nextInt(12000) + 3600;
            if (!serverInfo.func_76061_m() || serverInfo.func_76071_n() < duration) {
                serverInfo.func_76090_f(duration);
                serverInfo.func_76069_a(true);
            }
            if (!serverInfo.func_76059_o() || serverInfo.func_76083_p() < (duration += 1200)) {
                serverInfo.func_76080_g(duration);
                serverInfo.func_76084_b(true);
            }
        }
    }
}

