/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.creeper;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.entity.creeper._SpecialCreeperEntity;
import fathertoast.specialmobs.common.util.ExplosionHelper;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.FallingBlockEntity;
import net.minecraft.item.Items;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;

@SpecialMob
public class GravelCreeperEntity
extends _SpecialCreeperEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<GravelCreeperEntity> SPECIES;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(9472132).uniqueTextureBaseOnly().addExperience(1).burnImmune();
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Gravel Creeper", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        GravelCreeperEntity.addBaseLoot(loot);
        loot.addCommonDrop("common", (IItemProvider)Blocks.field_150351_n);
        loot.addUncommonDrop("uncommon", new IItemProvider[]{Items.field_151145_ak});
    }

    @SpecialMob.Factory
    public static EntityType.IFactory<GravelCreeperEntity> getVariantFactory() {
        return GravelCreeperEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends GravelCreeperEntity> getSpecies() {
        return SPECIES;
    }

    public GravelCreeperEntity(EntityType<? extends _SpecialCreeperEntity> entityType, World world) {
        super(entityType, world);
    }

    @Override
    protected float getVariantExplosionPower(float radius) {
        return super.getVariantExplosionPower(radius / 2.0f);
    }

    @Override
    protected void makeVariantExplosion(float explosionPower) {
        Explosion.Mode explosionMode = ExplosionHelper.getMode((Entity)this);
        ExplosionHelper explosion = new ExplosionHelper((Entity)this, explosionPower, explosionMode, false);
        if (!explosion.initializeExplosion()) {
            return;
        }
        explosion.finalizeExplosion();
        if (explosionMode == Explosion.Mode.NONE || this.field_70170_p.func_201670_d()) {
            return;
        }
        float throwPower = explosionPower + 4.0f;
        int count = (int)Math.ceil(throwPower * throwPower * 3.5f);
        for (int i = 0; i < count; ++i) {
            FallingBlockEntity gravel = new FallingBlockEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_() + (double)(this.func_213302_cg() / 2.0f), this.func_226281_cx_(), Blocks.field_150351_n.func_176223_P());
            gravel.field_145812_b = 1;
            gravel.field_145813_c = false;
            gravel.func_145806_a(true);
            gravel.field_70143_R = 3.0f;
            float speed = (throwPower * 0.7f + this.field_70146_Z.nextFloat() * throwPower) / 20.0f;
            float pitch = this.field_70146_Z.nextFloat() * (float)Math.PI;
            float yaw = this.field_70146_Z.nextFloat() * 2.0f * (float)Math.PI;
            gravel.func_213293_j((double)(MathHelper.func_76134_b((float)yaw) * speed), (double)(MathHelper.func_76126_a((float)pitch) * (throwPower + this.field_70146_Z.nextFloat() * throwPower) / 18.0f), (double)(MathHelper.func_76126_a((float)yaw) * speed));
            this.field_70170_p.func_217376_c((Entity)gravel);
        }
        this.func_70656_aK();
        this.func_184185_a(SoundEvents.field_187581_bW, 1.0f, 1.0f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (DamageSource.field_82729_p.func_76355_l().equals(source.func_76355_l()) || DamageSource.field_82728_o.func_76355_l().equals(source.func_76355_l())) {
            return true;
        }
        return super.func_70097_a(source, amount);
    }
}

