/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.creeper;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.config.species.CreeperSpeciesConfig;
import fathertoast.specialmobs.common.config.species.SpeciesConfig;
import fathertoast.specialmobs.common.entity.creeper._SpecialCreeperEntity;
import fathertoast.specialmobs.common.util.ExplosionHelper;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;

@SpecialMob
public class FireCreeperEntity
extends _SpecialCreeperEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<FireCreeperEntity> SPECIES;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(14760214).theme(BestiaryInfo.Theme.FIRE).uniqueTextureBaseOnly().addExperience(1).fireImmune().waterSensitive();
    }

    @SpecialMob.ConfigSupplier
    public static SpeciesConfig createConfig(MobFamily.Species<?> species) {
        return new CreeperSpeciesConfig(species, true, false, false);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Fire Creeper", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        FireCreeperEntity.addBaseLoot(loot);
        loot.addCommonDrop("common", (IItemProvider)Items.field_151059_bz);
        loot.addUncommonDrop("uncommon", new IItemProvider[]{Items.field_151044_h});
    }

    @SpecialMob.Factory
    public static EntityType.IFactory<FireCreeperEntity> getVariantFactory() {
        return FireCreeperEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends FireCreeperEntity> getSpecies() {
        return SPECIES;
    }

    public FireCreeperEntity(EntityType<? extends _SpecialCreeperEntity> entityType, World world) {
        super(entityType, world);
    }

    @Override
    protected void makeVariantExplosion(float explosionPower) {
        ExplosionHelper.explode((Entity)this, explosionPower, true, true);
    }
}

