/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.creeper;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.config.species.CreeperSpeciesConfig;
import fathertoast.specialmobs.common.config.species.SpeciesConfig;
import fathertoast.specialmobs.common.core.SpecialMobs;
import fathertoast.specialmobs.common.entity.ai.AIHelper;
import fathertoast.specialmobs.common.entity.creeper._SpecialCreeperEntity;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import java.util.EnumSet;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IAngerable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.ResetAngerGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.RangedInteger;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.TickRangeConverter;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.EntityTeleportEvent;

@SpecialMob
public class EnderCreeperEntity
extends _SpecialCreeperEntity
implements IAngerable {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<EnderCreeperEntity> SPECIES;
    private static final RangedInteger PERSISTENT_ANGER_TIME;
    private int remainingPersistentAngerTime;
    private UUID persistentAngerTarget;
    private static final DataParameter<Boolean> DATA_CREEPY;
    private static final DataParameter<Boolean> DATA_STARED_AT;
    private int lastStareSound = Integer.MIN_VALUE;
    private int targetChangeTime;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(13369594).weight(BestiaryInfo.DefaultWeight.LOW).uniqueTextureWithEyes().addExperience(2).waterSensitive().addToAttribute(Attributes.field_233818_a_, 20.0);
    }

    @SpecialMob.ConfigSupplier
    public static SpeciesConfig createConfig(MobFamily.Species<?> species) {
        return new CreeperSpeciesConfig(species, true, false, false);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Endercreeper", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        EnderCreeperEntity.addBaseLoot(loot);
        loot.addLootTable("common", EntityType.field_200803_q.func_220348_g());
    }

    @SpecialMob.Factory
    public static EntityType.IFactory<EnderCreeperEntity> getVariantFactory() {
        return EnderCreeperEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends EnderCreeperEntity> getSpecies() {
        return SPECIES;
    }

    public EnderCreeperEntity(EntityType<? extends _SpecialCreeperEntity> entityType, World world) {
        super(entityType, world);
    }

    @Override
    protected void registerVariantGoals() {
        AIHelper.insertGoal(this.field_70714_bg, 4, new StareGoal(this));
        AIHelper.removeGoals(this.field_70715_bh, NearestAttackableTargetGoal.class);
        this.field_70715_bh.func_75776_a(1, (Goal)new FindPlayerGoal(this, arg_0 -> ((EnderCreeperEntity)this).func_233680_b_(arg_0)));
        this.field_70715_bh.func_75776_a(4, (Goal)new ResetAngerGoal((MobEntity)this, false));
    }

    @Override
    public void addVariantSaveData(CompoundNBT saveTag) {
        this.func_233682_c_(saveTag);
    }

    @Override
    public void readVariantSaveData(CompoundNBT saveTag) {
        if (!this.field_70170_p.field_72995_K) {
            this.func_241358_a_((ServerWorld)this.field_70170_p, saveTag);
        }
    }

    public void func_230258_H__() {
        this.func_230260_a__(PERSISTENT_ANGER_TIME.func_233018_a_(this.field_70146_Z));
    }

    public void func_230260_a__(int ticks) {
        this.remainingPersistentAngerTime = ticks;
    }

    public int func_230256_F__() {
        return this.remainingPersistentAngerTime;
    }

    public void func_230259_a_(@Nullable UUID id) {
        this.persistentAngerTarget = id;
    }

    public UUID func_230257_G__() {
        return this.persistentAngerTarget;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DATA_CREEPY, (Object)false);
        this.field_70180_af.func_187214_a(DATA_STARED_AT, (Object)false);
    }

    public boolean isCreepy() {
        return (Boolean)this.field_70180_af.func_187225_a(DATA_CREEPY);
    }

    private boolean hasBeenStaredAt() {
        return (Boolean)this.field_70180_af.func_187225_a(DATA_STARED_AT);
    }

    private void setBeingStaredAt() {
        this.field_70180_af.func_187227_b(DATA_STARED_AT, (Object)true);
    }

    public void func_70624_b(@Nullable LivingEntity target) {
        if (target == null) {
            this.targetChangeTime = 0;
            this.field_70180_af.func_187227_b(DATA_CREEPY, (Object)false);
            this.field_70180_af.func_187227_b(DATA_STARED_AT, (Object)false);
        } else {
            this.targetChangeTime = this.field_70173_aa;
            this.field_70180_af.func_187227_b(DATA_CREEPY, (Object)true);
        }
        super.func_70624_b(target);
    }

    private void playStareSound() {
        if (this.field_70173_aa >= this.lastStareSound + 400) {
            this.lastStareSound = this.field_70173_aa;
            if (!this.func_174814_R()) {
                this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226280_cw_(), this.func_226281_cx_(), SoundEvents.field_187533_aW, this.func_184176_by(), 2.5f, 1.0f, false);
            }
        }
    }

    public void func_184206_a(DataParameter<?> parameter) {
        if (DATA_CREEPY.equals(parameter) && this.hasBeenStaredAt() && this.field_70170_p.field_72995_K) {
            this.playStareSound();
        }
        super.func_184206_a(parameter);
    }

    private boolean isLookingAtMe(PlayerEntity player) {
        ItemStack playerHelm = (ItemStack)player.field_71071_by.field_70460_b.get(3);
        try {
            if (playerHelm.isEnderMask(player, null)) {
                return false;
            }
        }
        catch (NullPointerException ex) {
            SpecialMobs.LOG.error("Helmet '{}' does not support nullable enderman for ::isEnderMask check!", (Object)playerHelm.func_77977_a());
            return false;
        }
        Vector3d playerViewVec = player.func_70676_i(1.0f).func_72432_b();
        Vector3d playerToThisVec = new Vector3d(this.func_226277_ct_() - player.func_226277_ct_(), this.func_226280_cw_() - player.func_226280_cw_(), this.func_226281_cx_() - player.func_226281_cx_());
        double distance = playerToThisVec.func_72433_c();
        double viewProjection = playerViewVec.func_72430_b(playerToThisVec.func_72432_b());
        return viewProjection > 1.0 - 0.025 / distance && player.func_70685_l((Entity)this);
    }

    @Override
    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 2; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197599_J, this.func_226282_d_(0.5), this.func_226279_cv_() - 0.25, this.func_226287_g_(0.5), (this.field_70146_Z.nextDouble() - 0.5) * 2.0, -this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0);
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            this.func_241359_a_((ServerWorld)this.field_70170_p, true);
        }
        super.func_70636_d();
    }

    protected void func_70619_bc() {
        float brightness;
        if (this.field_70170_p.func_72935_r() && this.field_70173_aa >= this.targetChangeTime + 600 && (brightness = this.func_70013_c()) > 0.5f && this.field_70170_p.func_226660_f_(this.func_233580_cy_()) && this.field_70146_Z.nextFloat() * 30.0f < (brightness - 0.4f) * 2.0f) {
            this.func_70624_b(null);
            this.teleport();
        }
        super.func_70619_bc();
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (source instanceof IndirectEntityDamageSource) {
            for (int i = 0; i < 64; ++i) {
                if (!this.teleport()) continue;
                return true;
            }
            return false;
        }
        boolean success = super.func_70097_a(source, amount);
        if (!this.field_70170_p.func_201670_d() && !(source.func_76346_g() instanceof LivingEntity) && this.field_70146_Z.nextInt(10) != 0) {
            this.teleport();
        }
        return success;
    }

    protected boolean teleport() {
        if (this.field_70170_p.func_201670_d() || !this.func_70089_S()) {
            return false;
        }
        double x = this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * 64.0;
        double y = this.func_226278_cu_() + (double)(this.field_70146_Z.nextInt(64) - 32);
        double z = this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * 64.0;
        return this.teleport(x, y, z);
    }

    protected boolean teleportTowards(Entity target) {
        Vector3d directionFromTarget = new Vector3d(this.func_226277_ct_() - target.func_226277_ct_(), this.func_226283_e_(0.5) - target.func_226280_cw_(), this.func_226281_cx_() - target.func_226281_cx_()).func_72432_b();
        double x = this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - directionFromTarget.field_72450_a * 16.0;
        double y = this.func_226278_cu_() + (double)(this.field_70146_Z.nextInt(16) - 8) - directionFromTarget.field_72448_b * 16.0;
        double z = this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - directionFromTarget.field_72449_c * 16.0;
        return this.teleport(x, y, z);
    }

    protected boolean teleport(double x, double y, double z) {
        BlockPos.Mutable pos = new BlockPos.Mutable(x, y, z);
        while (pos.func_177956_o() > 0 && !this.field_70170_p.func_180495_p((BlockPos)pos).func_185904_a().func_76230_c()) {
            pos.func_189536_c(Direction.DOWN);
        }
        BlockState block = this.field_70170_p.func_180495_p((BlockPos)pos);
        if (!block.func_185904_a().func_76230_c() || block.func_204520_s().func_206884_a((ITag)FluidTags.field_206959_a)) {
            return false;
        }
        EntityTeleportEvent.EnderEntity event = ForgeEventFactory.onEnderTeleport((LivingEntity)this, (double)x, (double)y, (double)z);
        if (event.isCanceled()) {
            return false;
        }
        boolean success = this.func_213373_a(event.getTargetX(), event.getTargetY(), event.getTargetZ(), true);
        if (success && !this.func_174814_R()) {
            this.field_70170_p.func_184148_a(null, this.field_70169_q, this.field_70167_r, this.field_70166_s, SoundEvents.field_187534_aX, this.func_184176_by(), 1.0f, 1.0f);
            this.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
        }
        return success;
    }

    static {
        PERSISTENT_ANGER_TIME = TickRangeConverter.func_233037_a_((int)20, (int)39);
        DATA_CREEPY = EntityDataManager.func_187226_a(EnderCreeperEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
        DATA_STARED_AT = EntityDataManager.func_187226_a(EnderCreeperEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    }

    static class FindPlayerGoal
    extends NearestAttackableTargetGoal<PlayerEntity> {
        private final EnderCreeperEntity creeper;
        private final EntityPredicate startAggroTargetConditions;
        private final EntityPredicate continueAggroTargetConditions = new EntityPredicate().func_221014_c();
        private PlayerEntity pendingTarget;
        private int aggroTime;
        private int teleportTime;

        public FindPlayerGoal(EnderCreeperEntity entity, @Nullable Predicate<LivingEntity> targetSelector) {
            super((MobEntity)entity, PlayerEntity.class, 10, false, false, targetSelector);
            this.creeper = entity;
            this.startAggroTargetConditions = new EntityPredicate().func_221013_a(this.func_111175_f()).func_221012_a(player -> entity.isLookingAtMe((PlayerEntity)player));
        }

        public boolean func_75250_a() {
            this.pendingTarget = this.creeper.field_70170_p.func_217370_a(this.startAggroTargetConditions, (LivingEntity)this.creeper);
            return this.pendingTarget != null;
        }

        public void func_75249_e() {
            this.aggroTime = 5;
            this.teleportTime = 0;
            this.creeper.setBeingStaredAt();
        }

        public void func_75251_c() {
            this.pendingTarget = null;
            super.func_75251_c();
        }

        public boolean func_75253_b() {
            if (this.pendingTarget != null) {
                if (!this.creeper.isLookingAtMe(this.pendingTarget)) {
                    return false;
                }
                this.creeper.func_70625_a((Entity)this.pendingTarget, 10.0f, 10.0f);
                return true;
            }
            return this.field_75309_a != null && this.continueAggroTargetConditions.func_221015_a((LivingEntity)this.creeper, this.field_75309_a) || super.func_75253_b();
        }

        public void func_75246_d() {
            if (this.creeper.func_70638_az() == null) {
                super.func_234054_a_(null);
            }
            if (this.pendingTarget != null) {
                if (--this.aggroTime <= 0) {
                    this.field_75309_a = this.pendingTarget;
                    this.pendingTarget = null;
                    super.func_75249_e();
                }
            } else {
                if (this.field_75309_a != null && !this.creeper.func_184218_aH()) {
                    if (this.creeper.isLookingAtMe((PlayerEntity)this.field_75309_a)) {
                        if (this.field_75309_a.func_70068_e((Entity)this.creeper) < 16.0) {
                            this.creeper.teleport();
                        }
                        this.teleportTime = 0;
                    } else if (this.field_75309_a.func_70068_e((Entity)this.creeper) > 256.0 && this.teleportTime++ >= 30 && this.creeper.teleportTowards((Entity)this.field_75309_a)) {
                        this.teleportTime = 0;
                    }
                }
                super.func_75246_d();
            }
        }
    }

    static class StareGoal
    extends Goal {
        private final EnderCreeperEntity creeper;
        private LivingEntity target;

        public StareGoal(EnderCreeperEntity entity) {
            this.creeper = entity;
            this.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            this.target = this.creeper.func_70638_az();
            return this.target instanceof PlayerEntity && this.target.func_70068_e((Entity)this.creeper) <= 256.0 && this.creeper.isLookingAtMe((PlayerEntity)this.target);
        }

        public void func_75249_e() {
            this.creeper.func_70661_as().func_75499_g();
        }

        public void func_75246_d() {
            this.creeper.func_70671_ap().func_220679_a(this.target.func_226277_ct_(), this.target.func_226280_cw_(), this.target.func_226281_cx_());
        }
    }
}

