/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.creeper;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.block.UnderwaterSilverfishBlock;
import fathertoast.specialmobs.common.config.species.DrowningCreeperSpeciesConfig;
import fathertoast.specialmobs.common.config.species.SpeciesConfig;
import fathertoast.specialmobs.common.config.util.EnvironmentEntry;
import fathertoast.specialmobs.common.config.util.EnvironmentList;
import fathertoast.specialmobs.common.config.util.environment.biome.BiomeCategory;
import fathertoast.specialmobs.common.entity.MobHelper;
import fathertoast.specialmobs.common.entity.ai.AIHelper;
import fathertoast.specialmobs.common.entity.ai.AmphibiousMovementController;
import fathertoast.specialmobs.common.entity.ai.IAmphibiousMob;
import fathertoast.specialmobs.common.entity.ai.goal.AmphibiousGoToWaterGoal;
import fathertoast.specialmobs.common.entity.ai.goal.AmphibiousSwimUpGoal;
import fathertoast.specialmobs.common.entity.creeper._SpecialCreeperEntity;
import fathertoast.specialmobs.common.event.NaturalSpawnManager;
import fathertoast.specialmobs.common.util.ExplosionHelper;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootEntryItemBuilder;
import fathertoast.specialmobs.datagen.loot.LootPoolBuilder;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.passive.fish.PufferfishEntity;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.SwimmerPathNavigator;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;

@SpecialMob
public class DrowningCreeperEntity
extends _SpecialCreeperEntity
implements IAmphibiousMob {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<DrowningCreeperEntity> SPECIES;
    private int pufferfish;
    private final SwimmerPathNavigator waterNavigation;
    private final GroundPathNavigator groundNavigation;
    private boolean swimmingUp;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(2966004).weight(BestiaryInfo.DefaultWeight.LOW).theme(BestiaryInfo.Theme.WATER).uniqueTextureWithEyes().addExperience(2).drownImmune().fluidPushImmune().addToAttribute(Attributes.field_233818_a_, 10.0);
    }

    @SpecialMob.ConfigSupplier
    public static SpeciesConfig createConfig(MobFamily.Species<?> species) {
        SpeciesConfig.NEXT_NATURAL_SPAWN_CHANCE_EXCEPTIONS = new EnvironmentList(EnvironmentEntry.builder(0.06f).inBiome((RegistryKey<Biome>)Biomes.field_203614_T).build(), EnvironmentEntry.builder(0.06f).inBiome((RegistryKey<Biome>)Biomes.field_203617_W).build(), EnvironmentEntry.builder(0.06f).inBiomeCategory(BiomeCategory.RIVER).build(), EnvironmentEntry.builder(0.02f).inBiomeCategory(BiomeCategory.OCEAN).belowSeaDepths().build(), EnvironmentEntry.builder(0.0f).inBiomeCategory(BiomeCategory.OCEAN).build());
        return new DrowningCreeperSpeciesConfig(species, false, false, false, 0.25, 2, 4);
    }

    @Override
    public DrowningCreeperSpeciesConfig getConfig() {
        return (DrowningCreeperSpeciesConfig)this.getSpecies().config;
    }

    @SpecialMob.SpawnPlacementRegistrar
    public static void registerSpeciesSpawnPlacement(MobFamily.Species<? extends DrowningCreeperEntity> species) {
        NaturalSpawnManager.registerSpawnPlacement(species, EntitySpawnPlacementRegistry.PlacementType.IN_WATER, DrowningCreeperEntity::checkSpeciesSpawnRules);
    }

    public static boolean checkSpeciesSpawnRules(EntityType<? extends DrowningCreeperEntity> type, IServerWorld world, SpawnReason reason, BlockPos pos, Random random) {
        Biome.Category biomeCategory = world.func_226691_t_(pos).func_201856_r();
        if (biomeCategory == Biome.Category.OCEAN || biomeCategory == Biome.Category.RIVER) {
            return NaturalSpawnManager.checkSpawnRulesWater(type, world, reason, pos, random);
        }
        return NaturalSpawnManager.checkSpawnRulesDefault(type, world, reason, pos, random);
    }

    public boolean func_205019_a(IWorldReader world) {
        return world.func_226668_i_((Entity)this);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Drowning Creeper", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        DrowningCreeperEntity.addBaseLoot(loot);
        loot.addPool(new LootPoolBuilder("common").addEntry(new LootEntryItemBuilder((IItemProvider)Items.field_196086_aW).setCount(0, 2).addLootingBonus(0.0f, 1.0f).smeltIfBurning().toLootEntry()).toLootPool());
        loot.addPool(new LootPoolBuilder("semicommon").addEntry(new LootEntryItemBuilder((IItemProvider)Items.field_196087_aX).setCount(0, 1).addLootingBonus(0.0f, 1.0f).smeltIfBurning().toLootEntry()).toLootPool());
        loot.addUncommonDrop("uncommon", new IItemProvider[]{Items.field_151074_bl, Items.field_179562_cC, Items.field_179563_cD});
    }

    @SpecialMob.Factory
    public static EntityType.IFactory<DrowningCreeperEntity> getVariantFactory() {
        return DrowningCreeperEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends DrowningCreeperEntity> getSpecies() {
        return SPECIES;
    }

    public DrowningCreeperEntity(EntityType<? extends _SpecialCreeperEntity> entityType, World world) {
        super(entityType, world);
        this.field_70765_h = new AmphibiousMovementController<DrowningCreeperEntity>(this);
        this.waterNavigation = new SwimmerPathNavigator((MobEntity)this, world);
        this.groundNavigation = new GroundPathNavigator((MobEntity)this, world);
        this.field_70138_W = 1.0f;
        this.func_184644_a(PathNodeType.WATER, PathNodeType.WALKABLE.func_186289_a());
        this.pufferfish = this.getConfig().DROWNING.puffPuffs.next(this.field_70146_Z);
    }

    @Override
    protected void registerVariantGoals() {
        AIHelper.removeGoals(this.field_70714_bg, SwimGoal.class);
        AIHelper.insertGoal(this.field_70714_bg, 5, new AmphibiousGoToWaterGoal((MobEntity)this, 1.0).alwaysEnabled());
        AIHelper.insertGoal(this.field_70714_bg, 6, new AmphibiousSwimUpGoal<DrowningCreeperEntity>(this, 1.0));
        AIHelper.replaceWaterAvoidingRandomWalking((CreatureEntity)this, 0.8);
    }

    @Override
    protected float getVariantExplosionPower(float radius) {
        return super.getVariantExplosionPower(radius) + 3.0f;
    }

    @Override
    protected void makeVariantExplosion(float explosionPower) {
        Explosion.Mode explosionMode = ExplosionHelper.getMode((Entity)this);
        ExplosionHelper explosion = new ExplosionHelper((Entity)this, explosionMode == Explosion.Mode.NONE ? explosionPower : 1.0f, explosionMode, false);
        if (!explosion.initializeExplosion()) {
            return;
        }
        explosion.finalizeExplosion();
        if (explosionMode == Explosion.Mode.NONE) {
            return;
        }
        UnderwaterSilverfishBlock.Type mainType = UnderwaterSilverfishBlock.Type.next(this.field_70146_Z);
        UnderwaterSilverfishBlock.Type rareType = UnderwaterSilverfishBlock.Type.next(this.field_70146_Z);
        BlockState mainCoral = mainType.hostBlock().func_176223_P();
        BlockState rareCoral = rareType.hostBlock().func_176223_P();
        BlockState mainInfestedCoral = mainType.block().func_176223_P();
        BlockState rareInfestedCoral = rareType.block().func_176223_P();
        BlockState water = Blocks.field_150355_j.func_176223_P();
        BlockState seaPickle = (BlockState)Blocks.field_204913_jW.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(true));
        BlockState seaGrass = Blocks.field_203198_aQ.func_176223_P();
        int radius = (int)Math.floor(explosionPower);
        int radiusSq = radius * radius;
        int rMinusOneSq = (radius - 1) * (radius - 1);
        BlockPos center = new BlockPos(explosion.getPos());
        if (this.pufferfish > 0) {
            this.spawnPufferfish(center.func_177981_b(1));
        }
        int pufferCount = 1;
        for (int y = -radius; y <= radius; ++y) {
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    BlockPos pos;
                    BlockState stateAtPos;
                    int distSq = x * x + y * y + z * z;
                    if (distSq > radiusSq || !(stateAtPos = this.field_70170_p.func_180495_p(pos = center.func_177982_a(x, y, z))).func_185904_a().func_76222_j() && !stateAtPos.func_235714_a_((ITag)BlockTags.field_206952_E)) continue;
                    if (distSq <= rMinusOneSq) {
                        float fillChoice = this.field_70146_Z.nextFloat();
                        if (fillChoice < 0.1f && seaPickle.func_196955_c((IWorldReader)this.field_70170_p, pos)) {
                            MobHelper.placeBlock((Entity)this, pos, seaPickle);
                            continue;
                        }
                        if (fillChoice < 0.3f && seaGrass.func_196955_c((IWorldReader)this.field_70170_p, pos)) {
                            MobHelper.placeBlock((Entity)this, pos, seaGrass);
                            continue;
                        }
                        MobHelper.placeBlock((Entity)this, pos, water);
                        if (!(this.field_70146_Z.nextFloat() < 0.0075f) || pufferCount >= this.pufferfish) continue;
                        this.spawnPufferfish(pos);
                        ++pufferCount;
                        continue;
                    }
                    if (!this.isCoralSafe(rMinusOneSq, x, y, z)) continue;
                    boolean infested = this.getConfig().DROWNING.infestedBlockChance.rollChance(this.field_70146_Z);
                    MobHelper.placeBlock((Entity)this, pos, this.field_70146_Z.nextFloat() < 0.8f ? (infested ? mainInfestedCoral : mainCoral) : (infested ? rareInfestedCoral : rareCoral));
                }
            }
        }
    }

    private void spawnPufferfish(BlockPos pos) {
        if (!(this.field_70170_p instanceof IServerWorld)) {
            return;
        }
        PufferfishEntity lePuffPuff = (PufferfishEntity)EntityType.field_203779_Z.func_200721_a(this.field_70170_p);
        if (lePuffPuff != null) {
            lePuffPuff.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
            this.field_70170_p.func_217376_c((Entity)lePuffPuff);
        }
    }

    private boolean isCoralSafe(int rMinusOneSq, int x, int y, int z) {
        int innerZ;
        int innerX;
        int innerY;
        int distSq;
        if (y != 0 && (distSq = x * x + (innerY = y < 0 ? y + 1 : y - 1) * innerY + z * z) <= rMinusOneSq) {
            return true;
        }
        if (x != 0 && (distSq = (innerX = x < 0 ? x + 1 : x - 1) * innerX + y * y + z * z) <= rMinusOneSq) {
            return true;
        }
        return z != 0 && (distSq = x * x + y * y + (innerZ = z < 0 ? z + 1 : z - 1) * innerZ) <= rMinusOneSq;
    }

    public boolean func_70026_G() {
        return true;
    }

    public boolean func_203008_ap() {
        return true;
    }

    @Override
    public void addVariantSaveData(CompoundNBT saveTag) {
        saveTag.func_74774_a("Summons", (byte)this.pufferfish);
    }

    @Override
    public void readVariantSaveData(CompoundNBT saveTag) {
        if (saveTag.func_150297_b("Summons", 99)) {
            this.pufferfish = saveTag.func_74771_c("Summons");
        }
        this.func_184644_a(PathNodeType.WATER, PathNodeType.WALKABLE.func_186289_a());
    }

    public void func_205343_av() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_70613_aW() && this.func_204231_K() && this.shouldSwim()) {
                this.setNavigatorToSwim();
                this.func_204711_a(true);
            } else {
                this.setNavigatorToGround();
                this.func_204711_a(false);
            }
        }
    }

    public void func_213352_e(Vector3d input) {
        if (this.func_70613_aW() && this.func_204231_K() && this.shouldSwim()) {
            this.func_213309_a(0.01f, input);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.9));
        } else {
            super.func_213352_e(input);
        }
    }

    protected float func_189749_co() {
        return 0.9f;
    }

    @Override
    public boolean shouldSwim() {
        if (this.swimmingUp) {
            return true;
        }
        LivingEntity target = this.func_70638_az();
        return target != null && target.func_70090_H();
    }

    @Override
    public void setSwimmingUp(boolean value) {
        this.swimmingUp = value;
    }

    @Override
    public boolean isSwimmingUp() {
        return this.swimmingUp;
    }

    @Override
    public void setNavigatorToSwim() {
        this.field_70699_by = this.waterNavigation;
    }

    @Override
    public void setNavigatorToGround() {
        this.field_70699_by = this.groundNavigation;
    }
}

