/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.creeper;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.entity.creeper._SpecialCreeperEntity;
import fathertoast.specialmobs.common.util.ExplosionHelper;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import java.util.List;
import net.minecraft.entity.AreaEffectCloudEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.world.World;

@SpecialMob
public class DoomCreeperEntity
extends _SpecialCreeperEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<DoomCreeperEntity> SPECIES;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(0x494949).theme(BestiaryInfo.Theme.FOREST).uniqueTextureWithOverlay().addExperience(1).effectImmune(Effects.field_76433_i, Effects.field_82731_v);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Doom Creeper", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        DoomCreeperEntity.addBaseLoot(loot);
        loot.addLootTable("common", EntityType.field_200759_ay.func_220348_g());
    }

    @SpecialMob.Factory
    public static EntityType.IFactory<DoomCreeperEntity> getVariantFactory() {
        return DoomCreeperEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends DoomCreeperEntity> getSpecies() {
        return SPECIES;
    }

    public DoomCreeperEntity(EntityType<? extends _SpecialCreeperEntity> entityType, World world) {
        super(entityType, world);
    }

    @Override
    protected float getVariantExplosionPower(float radius) {
        return super.getVariantExplosionPower(radius / 2.0f);
    }

    @Override
    protected void makeVariantExplosion(float explosionPower) {
        ExplosionHelper.explode((Entity)this, explosionPower, false, false);
    }

    @Override
    protected void modifyVariantLingeringCloudEffects(List<EffectInstance> potions) {
        potions.add(new EffectInstance(Effects.field_76433_i, 100, 1));
        potions.add(new EffectInstance(Effects.field_82731_v, 200));
    }

    @Override
    protected void modifyVariantLingeringCloud(AreaEffectCloudEntity potionCloud) {
        potionCloud.func_184483_a((float)this.field_82226_g * (this.func_225509_J__() ? 2.0f : 1.0f));
    }
}

