/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.creeper;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.entity.MobHelper;
import fathertoast.specialmobs.common.entity.creeper._SpecialCreeperEntity;
import fathertoast.specialmobs.common.util.ExplosionHelper;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;

@SpecialMob
public class DirtCreeperEntity
extends _SpecialCreeperEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<DirtCreeperEntity> SPECIES;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(7886139).uniqueTextureBaseOnly().addExperience(1).burnImmune().addToAttribute(Attributes.field_233826_i_, 6.0);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Dirt Creeper", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        DirtCreeperEntity.addBaseLoot(loot);
        loot.addCommonDrop("common", (IItemProvider)Blocks.field_150346_d);
        loot.addSemicommonDrop("semicommon", (IItemProvider)Items.field_151025_P);
        loot.addRareDrop("rare", new IItemProvider[]{Items.field_151172_bF, Items.field_151174_bG});
    }

    @SpecialMob.Factory
    public static EntityType.IFactory<DirtCreeperEntity> getVariantFactory() {
        return DirtCreeperEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends DirtCreeperEntity> getSpecies() {
        return SPECIES;
    }

    public DirtCreeperEntity(EntityType<? extends _SpecialCreeperEntity> entityType, World world) {
        super(entityType, world);
    }

    @Override
    protected void makeVariantExplosion(float explosionPower) {
        Explosion.Mode explosionMode = ExplosionHelper.getMode((Entity)this);
        ExplosionHelper explosion = new ExplosionHelper((Entity)this, explosionPower, false, false);
        if (!explosion.initializeExplosion()) {
            return;
        }
        explosion.finalizeExplosion();
        if (explosionMode == Explosion.Mode.NONE) {
            return;
        }
        BlockState dirt = Blocks.field_150346_d.func_176223_P();
        int radius = (int)Math.floor(explosionPower);
        BlockPos center = new BlockPos(explosion.getPos());
        for (int y = -radius; y <= radius; ++y) {
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    BlockPos pos;
                    if (x * x + y * y + z * z > radius * radius || !this.field_70170_p.func_180495_p(pos = center.func_177982_a(x, y, z)).func_185904_a().func_76222_j()) continue;
                    MobHelper.placeBlock((Entity)this, pos, dirt);
                }
            }
        }
    }
}

