/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.creeper;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.config.species.CreeperSpeciesConfig;
import fathertoast.specialmobs.common.config.species.SpeciesConfig;
import fathertoast.specialmobs.common.entity.creeper._SpecialCreeperEntity;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;

@SpecialMob
public class DeathCreeperEntity
extends _SpecialCreeperEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<DeathCreeperEntity> SPECIES;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(0xCD0000).uniqueTextureWithEyes().size(1.5f, 0.9f, 2.6f).addExperience(2).addToAttribute(Attributes.field_233818_a_, 10.0);
    }

    @SpecialMob.ConfigSupplier
    public static SpeciesConfig createConfig(MobFamily.Species<?> species) {
        return new CreeperSpeciesConfig(species, false, true, false);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Death Creeper", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        DeathCreeperEntity.addBaseLoot(loot);
        loot.addGuaranteedDrop("base", (IItemProvider)Items.field_151016_H, 1);
        loot.addRareDrop("rare", new IItemProvider[]{Blocks.field_150335_W});
    }

    @SpecialMob.Factory
    public static EntityType.IFactory<DeathCreeperEntity> getVariantFactory() {
        return DeathCreeperEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends DeathCreeperEntity> getSpecies() {
        return SPECIES;
    }

    public DeathCreeperEntity(EntityType<? extends _SpecialCreeperEntity> entityType, World world) {
        super(entityType, world);
    }

    @Override
    protected float getVariantExplosionPower(float radius) {
        return super.getVariantExplosionPower(radius + 1.0f);
    }
}

