/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.creeper;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.entity.creeper._SpecialCreeperEntity;
import fathertoast.specialmobs.common.util.ExplosionHelper;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

@SpecialMob
public class DarkCreeperEntity
extends _SpecialCreeperEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<DarkCreeperEntity> SPECIES;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(16383802).uniqueTextureWithEyes().addExperience(1);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Dark Creeper", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        DarkCreeperEntity.addBaseLoot(loot);
        loot.addClusterDrop("common", (IItemProvider)Blocks.field_150478_aa);
        loot.addRareDrop("rare", PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_151068_bn), (Potion)Potions.field_185234_f));
    }

    @SpecialMob.Factory
    public static EntityType.IFactory<DarkCreeperEntity> getVariantFactory() {
        return DarkCreeperEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends DarkCreeperEntity> getSpecies() {
        return SPECIES;
    }

    public DarkCreeperEntity(EntityType<? extends _SpecialCreeperEntity> entityType, World world) {
        super(entityType, world);
    }

    @Override
    protected float getVariantExplosionPower(float radius) {
        return super.getVariantExplosionPower(radius / 2.0f);
    }

    @Override
    protected void makeVariantExplosion(float explosionPower) {
        ExplosionHelper explosion = new ExplosionHelper((Entity)this, explosionPower, true, false);
        if (!explosion.initializeExplosion()) {
            return;
        }
        BlockPos center = new BlockPos(explosion.getPos());
        int radius = this.field_82226_g * 4 * (this.func_225509_J__() ? 2 : 1);
        for (int y = -radius; y <= radius; ++y) {
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    BlockPos pos;
                    BlockState block;
                    if (x * x + y * y + z * z > radius * radius || (block = this.field_70170_p.func_180495_p(pos = center.func_177982_a(x, y, z))).getLightValue((IBlockReader)this.field_70170_p, pos) <= 1 || explosion.getHitBlocks().contains(pos) || !explosion.tryExplodeBlock(pos, block, radius)) continue;
                    explosion.getHitBlocks().add(pos);
                }
            }
        }
        explosion.finalizeExplosion();
        if (this.func_225509_J__() && this.field_70170_p instanceof ServerWorld) {
            ServerWorld serverLevel = (ServerWorld)this.field_70170_p;
            long time = serverLevel.func_72820_D();
            int dayTime = (int)(time % 24000L);
            time += 13000L - (long)dayTime;
            if (dayTime > 13000) {
                time += 24000L;
            }
            serverLevel.func_241114_a_(time);
        }
    }

    @Override
    protected void modifyVariantLingeringCloudEffects(List<EffectInstance> potions) {
        potions.add(new EffectInstance(Effects.field_76440_q, 100));
    }
}

