/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.cavespider;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.config.species.SpeciesConfig;
import fathertoast.specialmobs.common.config.species.SpiderSpeciesConfig;
import fathertoast.specialmobs.common.entity.ISpecialMob;
import fathertoast.specialmobs.common.entity.MobHelper;
import fathertoast.specialmobs.common.entity.SpecialMobData;
import fathertoast.specialmobs.common.entity.ai.goal.PassiveRangedAttackGoal;
import fathertoast.specialmobs.common.entity.projectile.BugSpitEntity;
import fathertoast.specialmobs.common.event.NaturalSpawnManager;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.monster.CaveSpiderEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.SnowballEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;

@SpecialMob
public class _SpecialCaveSpiderEntity
extends CaveSpiderEntity
implements IRangedAttackMob,
ISpecialMob<_SpecialCaveSpiderEntity> {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<_SpecialCaveSpiderEntity> SPECIES;
    protected static final double DEFAULT_SPIT_CHANCE = 0.05;
    private static final DataParameter<Float> SCALE;
    private SpecialMobData<_SpecialCaveSpiderEntity> specialData;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(11013646).familySize(0.7f).vanillaTextureWithEyes("textures/entity/spider/cave_spider.png", "textures/entity/spider_eyes.png").experience(5).spider().spitAttack(2.0, 1.4, 20, 40, 10.0);
    }

    @SpecialMob.ConfigSupplier
    public static SpeciesConfig createConfig(MobFamily.Species<?> species) {
        return new SpiderSpeciesConfig(species, 0.05);
    }

    public SpiderSpeciesConfig getConfig() {
        return (SpiderSpeciesConfig)this.getSpecies().config;
    }

    @SpecialMob.AttributeSupplier
    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return CaveSpiderEntity.func_234305_eI_();
    }

    @SpecialMob.SpawnPlacementRegistrar
    public static void registerSpawnPlacement(MobFamily.Species<? extends _SpecialCaveSpiderEntity> species) {
        NaturalSpawnManager.registerSpawnPlacement(species);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Cave Spider", "Ara\u00c3\u00b1a de cueva", "Aranha venenosa", "Araign\u00c3\u00a9e venimeuse", "Ragno delle caverne", "H\u00c3\u00b6hlenspinne", "Cave Horror");
    }

    @SpecialMob.LootTableProvider
    public static void addBaseLoot(LootTableBuilder loot) {
        loot.addLootTable("main", EntityType.field_200794_h.func_220348_g());
    }

    @SpecialMob.Factory
    public static EntityType.IFactory<_SpecialCaveSpiderEntity> getFactory() {
        return _SpecialCaveSpiderEntity::new;
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(4, new PassiveRangedAttackGoal<_SpecialCaveSpiderEntity>(this, 0.5f));
        this.registerVariantGoals();
    }

    protected void registerVariantGoals() {
    }

    public void finalizeVariantSpawn(IServerWorld world, DifficultyInstance difficulty, @Nullable SpawnReason spawnReason, @Nullable ILivingEntityData groupData) {
    }

    public void func_82196_d(LivingEntity target, float damageMulti) {
        BugSpitEntity spit = new BugSpitEntity((LivingEntity)this, target);
        spit.setColor(this.getVariantSpitColor());
        this.func_184185_a(SoundEvents.field_187821_fM, 0.6f, this.field_70146_Z.nextFloat() * 0.4f + 1.6f);
        this.field_70170_p.func_217376_c((Entity)spit);
    }

    protected int getVariantSpitColor() {
        return Effects.field_76436_u.func_76401_j();
    }

    public void func_174815_a(LivingEntity attacker, Entity target) {
        if (target instanceof LivingEntity) {
            this.onVariantAttack((LivingEntity)target);
        }
        super.func_174815_a(attacker, target);
    }

    protected void onVariantAttack(LivingEntity target) {
    }

    public void addVariantSaveData(CompoundNBT saveTag) {
    }

    public void readVariantSaveData(CompoundNBT saveTag) {
    }

    public _SpecialCaveSpiderEntity(EntityType<? extends _SpecialCaveSpiderEntity> entityType, World world) {
        super(entityType, world);
        if (!this.getConfig().SPIDERS.spitterChance.rollChance(this.field_70146_Z)) {
            this.getSpecialData().disableRangedAttack();
        }
        this.getSpecialData().initialize();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.specialData = new SpecialMobData<_SpecialCaveSpiderEntity>(this, SCALE);
    }

    @Override
    public final SpecialMobData<_SpecialCaveSpiderEntity> getSpecialData() {
        return this.specialData;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends _SpecialCaveSpiderEntity> getSpecies() {
        return SPECIES;
    }

    @Override
    public final int getExperience() {
        return this.field_70728_aV;
    }

    @Override
    public final void setExperience(int xp) {
        this.field_70728_aV = xp;
    }

    @Nullable
    public <T extends MobEntity> T func_233656_b_(EntityType<T> entityType, boolean keepEquipment) {
        MobEntity replacement = super.func_233656_b_(entityType, keepEquipment);
        if (replacement instanceof ISpecialMob && this.field_70170_p instanceof IServerWorld) {
            MobHelper.finalizeSpawn((LivingEntity)replacement, (IServerWorld)this.field_70170_p, this.field_70170_p.func_175649_E(this.func_233580_cy_()), SpawnReason.CONVERSION, null);
        }
        return (T)replacement;
    }

    @Nullable
    public final ILivingEntityData func_213386_a(IServerWorld world, DifficultyInstance difficulty, SpawnReason spawnReason, @Nullable ILivingEntityData groupData, @Nullable CompoundNBT eggTag) {
        return MobHelper.finalizeSpawn((LivingEntity)this, world, difficulty, spawnReason, super.func_213386_a(world, difficulty, spawnReason, groupData, eggTag));
    }

    @Override
    public void setSpecialPathfindingMalus(PathNodeType nodeType, float malus) {
        this.func_184644_a(nodeType, malus);
    }

    protected final void func_180481_a(DifficultyInstance difficulty) {
        super.func_180481_a(difficulty);
    }

    @Override
    public void finalizeSpecialSpawn(IServerWorld world, DifficultyInstance difficulty, @Nullable SpawnReason spawnReason, @Nullable ILivingEntityData groupData) {
        this.finalizeVariantSpawn(world, difficulty, spawnReason, groupData);
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.getSpecialData().tick();
    }

    protected float func_213348_b(Pose pose, EntitySize size) {
        return super.func_213348_b(pose, size) * this.getSpecialData().getHeightScaleByAge();
    }

    public boolean func_230279_az_() {
        return this.getSpecialData().isImmuneToFire();
    }

    public void func_241209_g_(int ticks) {
        if (!this.getSpecialData().isImmuneToBurning()) {
            super.func_241209_g_(ticks);
        }
    }

    public boolean func_184652_a(PlayerEntity player) {
        return !this.func_110167_bD() && this.getSpecialData().allowLeashing();
    }

    public void func_213295_a(BlockState block, Vector3d speedMulti) {
        if (this.getSpecialData().canBeStuckIn(block)) {
            super.func_213295_a(block, speedMulti);
        }
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return super.func_225503_b_(distance, damageMultiplier * this.getSpecialData().getFallDamageMultiplier());
    }

    public boolean func_145773_az() {
        return this.getSpecialData().ignorePressurePlates();
    }

    public boolean func_70648_aU() {
        return this.getSpecialData().canBreatheInWater();
    }

    public boolean func_96092_aw() {
        return !this.getSpecialData().ignoreWaterPush();
    }

    public boolean func_230270_dK_() {
        return this.getSpecialData().isDamagedByWater();
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_230270_dK_() && source.func_76364_f() instanceof SnowballEntity) {
            amount = Math.max(3.0f, amount);
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_70687_e(EffectInstance effect) {
        return this.getSpecialData().isPotionApplicable(effect);
    }

    public void func_213281_b(CompoundNBT tag) {
        super.func_213281_b(tag);
        CompoundNBT saveTag = SpecialMobData.getSaveLocation(tag);
        this.getSpecialData().writeToNBT(saveTag);
        this.addVariantSaveData(saveTag);
    }

    public void func_70037_a(CompoundNBT tag) {
        super.func_70037_a(tag);
        CompoundNBT saveTag = SpecialMobData.getSaveLocation(tag);
        this.getSpecialData().readFromNBT(saveTag);
        this.readVariantSaveData(saveTag);
    }

    static {
        SCALE = EntityDataManager.func_187226_a(_SpecialCaveSpiderEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    }
}

