/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.cavespider;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.entity.MobHelper;
import fathertoast.specialmobs.common.entity.ai.AIHelper;
import fathertoast.specialmobs.common.entity.ai.FluidPathNavigator;
import fathertoast.specialmobs.common.entity.cavespider._SpecialCaveSpiderEntity;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootEntryItemBuilder;
import fathertoast.specialmobs.datagen.loot.LootPoolBuilder;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;

@SpecialMob
public class WaterCaveSpiderEntity
extends _SpecialCaveSpiderEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<WaterCaveSpiderEntity> SPECIES;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(2966004).theme(BestiaryInfo.Theme.WATER).uniqueTextureWithEyes().addExperience(1).drownImmune().fluidPushImmune().addToAttribute(Attributes.field_233823_f_, 1.0);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Water Cave Spider", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        WaterCaveSpiderEntity.addBaseLoot(loot);
        loot.addPool(new LootPoolBuilder("common").addEntry(new LootEntryItemBuilder((IItemProvider)Items.field_196086_aW).setCount(0, 2).addLootingBonus(0.0f, 1.0f).smeltIfBurning().toLootEntry()).toLootPool());
        loot.addPool(new LootPoolBuilder("semicommon").addEntry(new LootEntryItemBuilder((IItemProvider)Items.field_196087_aX).setCount(0, 1).addLootingBonus(0.0f, 1.0f).smeltIfBurning().toLootEntry()).toLootPool());
    }

    @SpecialMob.Factory
    public static EntityType.IFactory<WaterCaveSpiderEntity> getVariantFactory() {
        return WaterCaveSpiderEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends WaterCaveSpiderEntity> getSpecies() {
        return SPECIES;
    }

    public WaterCaveSpiderEntity(EntityType<? extends _SpecialCaveSpiderEntity> entityType, World world) {
        super(entityType, world);
        this.func_184644_a(PathNodeType.WATER, PathNodeType.WALKABLE.func_186289_a());
    }

    @Override
    protected void registerVariantGoals() {
        AIHelper.replaceWaterAvoidingRandomWalking((CreatureEntity)this, 0.8);
    }

    protected PathNavigator func_175447_b(World world) {
        return new FluidPathNavigator((MobEntity)this, world, true, false);
    }

    public boolean func_230285_a_(Fluid fluid) {
        return fluid.func_207185_a((ITag)FluidTags.field_206959_a);
    }

    @Override
    protected int getVariantSpitColor() {
        return 3694022;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        MobHelper.floatInFluid((Entity)this, 0.06, (ITag<Fluid>)FluidTags.field_206959_a);
    }

    @Override
    public void readVariantSaveData(CompoundNBT saveTag) {
        this.func_184644_a(PathNodeType.WATER, PathNodeType.WALKABLE.func_186289_a());
    }
}

