/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.cavespider;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.config.Config;
import fathertoast.specialmobs.common.core.register.SMEffects;
import fathertoast.specialmobs.common.entity.MobHelper;
import fathertoast.specialmobs.common.entity.cavespider._SpecialCaveSpiderEntity;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.item.Items;
import net.minecraft.potion.Effect;
import net.minecraft.potion.Effects;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;

@SpecialMob
public class DesertCaveSpiderEntity
extends _SpecialCaveSpiderEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<DesertCaveSpiderEntity> SPECIES;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(15130028).theme(BestiaryInfo.Theme.DESERT).uniqueTextureWithEyes().size(0.6f, 0.7f, 0.5f).addExperience(2).effectImmune(Effects.field_76421_d, SMEffects.VULNERABILITY).addToAttribute(Attributes.field_233818_a_, 4.0);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Desert Cave Spider", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        DesertCaveSpiderEntity.addBaseLoot(loot);
        loot.addCommonDrop("common", (IItemProvider)Items.field_151116_aA);
    }

    @SpecialMob.Factory
    public static EntityType.IFactory<DesertCaveSpiderEntity> getVariantFactory() {
        return DesertCaveSpiderEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends DesertCaveSpiderEntity> getSpecies() {
        return SPECIES;
    }

    public DesertCaveSpiderEntity(EntityType<? extends _SpecialCaveSpiderEntity> entityType, World world) {
        super(entityType, world);
    }

    @Override
    protected int getVariantSpitColor() {
        return Effects.field_76440_q.func_76401_j();
    }

    @Override
    protected void onVariantAttack(LivingEntity target) {
        if (Config.MAIN.GENERAL.enableNausea.get()) {
            MobHelper.applyEffect(target, Effects.field_76431_k);
        }
        MobHelper.applyEffect(target, Effects.field_76440_q);
        MobHelper.removeNightVision(target);
        MobHelper.applyEffect(target, Effects.field_76421_d, 2);
        MobHelper.applyEffect(target, (Effect)SMEffects.VULNERABILITY.get());
    }
}

