/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.blaze;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.config.species.SpeciesConfig;
import fathertoast.specialmobs.common.config.species.WildfireBlazeSpeciesConfig;
import fathertoast.specialmobs.common.entity.blaze.CinderBlazeEntity;
import fathertoast.specialmobs.common.entity.blaze._SpecialBlazeEntity;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;

@SpecialMob
public class WildfireBlazeEntity
extends _SpecialBlazeEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<WildfireBlazeEntity> SPECIES;
    private int babies;
    private int summons;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(16051762).uniqueTextureBaseOnly().size(1.5f, 0.9f, 2.7f).addExperience(2).regen(40).fireballAttack(0.1, 30, 50, 20.0).addToAttribute(Attributes.field_233818_a_, 20.0);
    }

    @SpecialMob.ConfigSupplier
    public static SpeciesConfig createConfig(MobFamily.Species<?> species) {
        return new WildfireBlazeSpeciesConfig(species, 1, 0, 3, 6, 4, 10);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Wildfire", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        WildfireBlazeEntity.addBaseLoot(loot);
        loot.addCommonDrop("common", (IItemProvider)Items.field_151044_h, 1);
        loot.addUncommonDrop("uncommon", new IItemProvider[]{Items.field_196159_ct});
    }

    @SpecialMob.Factory
    public static EntityType.IFactory<WildfireBlazeEntity> getVariantFactory() {
        return WildfireBlazeEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends WildfireBlazeEntity> getSpecies() {
        return SPECIES;
    }

    public WildfireBlazeEntity(EntityType<? extends _SpecialBlazeEntity> entityType, World world) {
        super(entityType, world);
        this.babies = this.getConfig().WILDFIRE.babies.next(this.field_70146_Z);
        this.summons = this.getConfig().WILDFIRE.summons.next(this.field_70146_Z);
    }

    @Override
    public WildfireBlazeSpeciesConfig getConfig() {
        return (WildfireBlazeSpeciesConfig)this.getSpecies().config;
    }

    @Override
    protected void onVariantAttack(LivingEntity target) {
        target.func_70015_d(8);
    }

    @Override
    public void func_82196_d(LivingEntity target, float damageMulti) {
        if (!this.field_70170_p.func_201670_d() && this.summons > 0 && this.field_70146_Z.nextInt(2) == 0) {
            --this.summons;
            double vX = target.func_226277_ct_() - this.func_226277_ct_();
            double vZ = target.func_226281_cx_() - this.func_226281_cx_();
            double vH = Math.sqrt(vX * vX + vZ * vZ);
            this.spawnBaby(vX / vH * 0.8 + this.func_213322_ci().field_72450_a * 0.2, vZ / vH * 0.8 + this.func_213322_ci().field_72449_c * 0.2, null);
            this.func_70656_aK();
            References.LevelEvent.BLAZE_SHOOT.play((Entity)this);
        } else {
            super.func_82196_d(target, damageMulti);
        }
    }

    public void remove(boolean keepData) {
        if (this.func_233643_dh_() && !this.field_70128_L && this.field_70170_p instanceof IServerWorld) {
            ILivingEntityData groupData = null;
            for (int i = 0; i < this.babies; ++i) {
                groupData = this.spawnBaby((this.field_70146_Z.nextDouble() - 0.5) * 0.3, (this.field_70146_Z.nextDouble() - 0.5) * 0.3, groupData);
            }
            this.func_70656_aK();
            References.LevelEvent.BLAZE_SHOOT.play((Entity)this);
        }
        super.remove(keepData);
    }

    @Nullable
    private ILivingEntityData spawnBaby(double vX, double vZ, @Nullable ILivingEntityData groupData) {
        CinderBlazeEntity baby = (CinderBlazeEntity)((EntityType)CinderBlazeEntity.SPECIES.entityType.get()).func_200721_a(this.field_70170_p);
        if (baby == null) {
            return groupData;
        }
        baby.func_82149_j((Entity)this);
        baby.field_70759_as = this.field_70177_z;
        baby.field_70761_aq = this.field_70177_z;
        groupData = baby.func_213386_a((IServerWorld)this.field_70170_p, this.field_70170_p.func_175649_E(this.func_233580_cy_()), SpawnReason.MOB_SUMMONED, groupData, null);
        baby.func_70624_b(this.func_70638_az());
        baby.func_213293_j(vX, 0.0, vZ);
        baby.func_230245_c_(false);
        this.field_70170_p.func_217376_c((Entity)baby);
        return groupData;
    }

    @Override
    public void addVariantSaveData(CompoundNBT saveTag) {
        saveTag.func_74774_a("Babies", (byte)this.babies);
        saveTag.func_74774_a("Summons", (byte)this.summons);
    }

    @Override
    public void readVariantSaveData(CompoundNBT saveTag) {
        if (saveTag.func_150297_b("Babies", 99)) {
            this.babies = saveTag.func_74771_c("Babies");
        }
        if (saveTag.func_150297_b("Summons", 99)) {
            this.summons = saveTag.func_74771_c("Summons");
        }
    }
}

