/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.blaze;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.entity.blaze._SpecialBlazeEntity;
import fathertoast.specialmobs.common.util.ExplosionHelper;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.item.Items;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.EntityTeleportEvent;

@SpecialMob
public class JoltBlazeEntity
extends _SpecialBlazeEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<JoltBlazeEntity> SPECIES;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(4824238).uniqueTextureBaseOnly().addExperience(2).disableRangedAttack().addToAttribute(Attributes.field_233818_a_, 10.0).addToAttribute(Attributes.field_233826_i_, 10.0).multiplyAttribute(Attributes.field_233821_d_, 1.3);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Jolt", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        JoltBlazeEntity.addBaseLoot(loot);
        loot.addCommonDrop("common", (IItemProvider)Items.field_151137_ax);
    }

    @SpecialMob.Factory
    public static EntityType.IFactory<JoltBlazeEntity> getVariantFactory() {
        return JoltBlazeEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends JoltBlazeEntity> getSpecies() {
        return SPECIES;
    }

    public JoltBlazeEntity(EntityType<? extends _SpecialBlazeEntity> entityType, World world) {
        super(entityType, world);
    }

    @Override
    public void func_70636_d() {
        if (!this.field_70170_p.func_201670_d() && this.func_70089_S() && this.func_70638_az() != null && this.field_70146_Z.nextInt(20) == 0 && this.func_70068_e((Entity)this.func_70638_az()) > 256.0) {
            for (int i = 0; i < 16 && !this.teleportTowards((Entity)this.func_70638_az()); ++i) {
            }
        }
        super.func_70636_d();
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source) || this.func_230279_az_() && source.func_76347_k()) {
            return false;
        }
        if (source instanceof IndirectEntityDamageSource) {
            for (int i = 0; i < 64; ++i) {
                if (!this.teleport()) continue;
                return true;
            }
            return false;
        }
        boolean success = super.func_70097_a(source, amount);
        if (!this.field_70170_p.func_201670_d() && this.func_110143_aJ() > 0.0f) {
            if (source.func_76346_g() instanceof LivingEntity) {
                for (int i = 0; i < 16 && !this.teleport(); ++i) {
                }
            } else if (this.field_70146_Z.nextInt(10) != 0) {
                this.teleport();
            }
        }
        return success;
    }

    public void func_241841_a(ServerWorld world, LightningBoltEntity lightningBolt) {
    }

    protected boolean teleport() {
        if (this.field_70170_p.func_201670_d() || !this.func_70089_S()) {
            return false;
        }
        double x = this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * 32.0;
        double y = this.func_226278_cu_() + (double)(this.field_70146_Z.nextInt(16) - 8);
        double z = this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * 32.0;
        return this.teleport(x, y, z);
    }

    protected boolean teleportTowards(Entity target) {
        Vector3d directionFromTarget = new Vector3d(this.func_226277_ct_() - target.func_226277_ct_(), this.func_226283_e_(0.5) - target.func_226280_cw_(), this.func_226281_cx_() - target.func_226281_cx_()).func_72432_b();
        double x = this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - directionFromTarget.field_72450_a * 16.0;
        double y = this.func_226278_cu_() + (double)(this.field_70146_Z.nextInt(8) - 2) - directionFromTarget.field_72448_b * 16.0;
        double z = this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - directionFromTarget.field_72449_c * 16.0;
        return this.teleport(x, y, z);
    }

    protected boolean teleport(double x, double y, double z) {
        BlockPos.Mutable pos = new BlockPos.Mutable(x, y, z);
        while (pos.func_177956_o() > 0 && !this.field_70170_p.func_180495_p((BlockPos)pos).func_185904_a().func_76230_c()) {
            pos.func_189536_c(Direction.DOWN);
        }
        BlockState block = this.field_70170_p.func_180495_p((BlockPos)pos);
        if (!block.func_185904_a().func_76230_c() || block.func_204520_s().func_206884_a((ITag)FluidTags.field_206959_a)) {
            return false;
        }
        EntityTeleportEvent.EnderEntity event = ForgeEventFactory.onEnderTeleport((LivingEntity)this, (double)x, (double)y, (double)z);
        if (event.isCanceled()) {
            return false;
        }
        boolean success = this.func_213373_a(event.getTargetX(), event.getTargetY(), event.getTargetZ(), false);
        if (success) {
            ExplosionHelper.spawnLightning(this.field_70170_p, this.field_70169_q, this.field_70167_r, this.field_70166_s);
            ExplosionHelper.spawnLightning(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        }
        return success;
    }
}

