/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.blaze;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.config.species.BlazeSpeciesConfig;
import fathertoast.specialmobs.common.config.species.SpeciesConfig;
import fathertoast.specialmobs.common.entity.blaze._SpecialBlazeEntity;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.projectile.FireballEntity;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

@SpecialMob
public class HellfireBlazeEntity
extends _SpecialBlazeEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<HellfireBlazeEntity> SPECIES;
    private int explosionPower = 2;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(0xDDDDDD).uniqueTextureBaseOnly().size(1.1f, 0.7f, 1.99f).addExperience(2).fireballAttack(0.05, 60, 100, 40.0).addToAttribute(Attributes.field_233818_a_, 10.0);
    }

    @SpecialMob.ConfigSupplier
    public static SpeciesConfig createConfig(MobFamily.Species<?> species) {
        return new BlazeSpeciesConfig(species, 1, 0);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Hellfire", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        HellfireBlazeEntity.addBaseLoot(loot);
        loot.addCommonDrop("common", (IItemProvider)Items.field_151016_H);
    }

    @SpecialMob.Factory
    public static EntityType.IFactory<HellfireBlazeEntity> getVariantFactory() {
        return HellfireBlazeEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends HellfireBlazeEntity> getSpecies() {
        return SPECIES;
    }

    public HellfireBlazeEntity(EntityType<? extends _SpecialBlazeEntity> entityType, World world) {
        super(entityType, world);
    }

    @Override
    public void func_82196_d(LivingEntity target, float damageMulti) {
        References.LevelEvent.BLAZE_SHOOT.play((Entity)this);
        float accelVariance = MathHelper.func_76129_c((float)this.func_70032_d((Entity)target)) * 0.5f * this.getSpecialData().getRangedAttackSpread();
        double dX = target.func_226277_ct_() - this.func_226277_ct_() + this.func_70681_au().nextGaussian() * (double)accelVariance;
        double dY = target.func_226283_e_(0.5) - this.func_226283_e_(0.5);
        double dZ = target.func_226281_cx_() - this.func_226281_cx_() + this.func_70681_au().nextGaussian() * (double)accelVariance;
        FireballEntity fireball = new FireballEntity(this.field_70170_p, (LivingEntity)this, dX, dY, dZ);
        fireball.field_92057_e = this.explosionPower;
        fireball.func_70107_b(fireball.func_226277_ct_(), this.func_226283_e_(0.5) + 0.5, fireball.func_226281_cx_());
        this.field_70170_p.func_217376_c((Entity)fireball);
    }

    @Override
    public void addVariantSaveData(CompoundNBT saveTag) {
        saveTag.func_74774_a("ExplosionPower", (byte)this.explosionPower);
    }

    @Override
    public void readVariantSaveData(CompoundNBT saveTag) {
        if (saveTag.func_150297_b("ExplosionPower", 99)) {
            this.explosionPower = saveTag.func_74771_c("ExplosionPower");
        }
    }
}

