/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.blaze;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.entity.MobHelper;
import fathertoast.specialmobs.common.entity.blaze._SpecialBlazeEntity;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import java.util.UUID;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.projectile.SnowballEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

@SpecialMob
public class ConflagrationBlazeEntity
extends _SpecialBlazeEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<ConflagrationBlazeEntity> SPECIES;
    private static final AttributeModifier DAMAGE_BOOST;
    private int growthLevel;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(16775294).weight(BestiaryInfo.DefaultWeight.LOW).uniqueTextureBaseOnly().size(1.5f, 0.9f, 2.7f).addExperience(4).regen(20);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Conflagration", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        ConflagrationBlazeEntity.addBaseLoot(loot);
        loot.addCommonDrop("common", (IItemProvider)Items.field_151059_bz);
        loot.addRareDrop("rare", PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_151068_bn), (Potion)Potions.field_185241_m));
    }

    @SpecialMob.Factory
    public static EntityType.IFactory<ConflagrationBlazeEntity> getVariantFactory() {
        return ConflagrationBlazeEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends ConflagrationBlazeEntity> getSpecies() {
        return SPECIES;
    }

    public ConflagrationBlazeEntity(EntityType<? extends _SpecialBlazeEntity> entityType, World world) {
        super(entityType, world);
    }

    @Override
    protected void onVariantAttack(LivingEntity target) {
        MobHelper.stealLife((LivingEntity)this, target, 2.0f);
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source) || this.func_230279_az_() && source.func_76347_k()) {
            return false;
        }
        if (!(source.func_94541_c() || source.func_82725_o() || DamageSource.field_76369_e.func_76355_l().equals(source.func_76355_l()) || source.func_76364_f() instanceof SnowballEntity)) {
            if (!this.field_70170_p.func_201670_d() && this.growthLevel < 7) {
                ++this.growthLevel;
                this.updateFeedingLevels();
            }
            amount /= 2.0f;
        }
        return super.func_70097_a(source, amount);
    }

    private void updateFeedingLevels() {
        if (this.field_70170_p != null && !this.field_70170_p.field_72995_K) {
            int cooldownReduction = MathHelper.func_76128_c((double)((double)(this.getConfig().GENERAL.rangedAttackCooldown.get() * this.growthLevel) * 0.1));
            this.getSpecialData().setRangedAttackCooldown(this.getConfig().GENERAL.rangedAttackCooldown.get() - cooldownReduction);
            this.getSpecialData().setRangedAttackMaxCooldown(this.getConfig().GENERAL.rangedAttackMaxCooldown.get() - cooldownReduction);
            this.fireballBurstCount = this.getConfig().BLAZES.fireballBurstCount.get();
            if (this.growthLevel >= 3) {
                ++this.fireballBurstCount;
            }
            if (this.growthLevel >= 7) {
                ++this.fireballBurstCount;
            }
            ModifiableAttributeInstance damage = this.func_110148_a(Attributes.field_233823_f_);
            damage.func_188479_b(DAMAGE_BOOST.func_111167_a());
            if (this.growthLevel > 0) {
                damage.func_233769_c_(new AttributeModifier(DAMAGE_BOOST.func_111167_a(), DAMAGE_BOOST.func_111166_b(), DAMAGE_BOOST.func_111164_d() * (double)this.growthLevel, DAMAGE_BOOST.func_220375_c()));
            }
        }
    }

    @Override
    public void addVariantSaveData(CompoundNBT saveTag) {
        saveTag.func_74774_a("GrowthLevel", (byte)this.growthLevel);
    }

    @Override
    public void readVariantSaveData(CompoundNBT saveTag) {
        if (saveTag.func_150297_b("GrowthLevel", 99)) {
            this.growthLevel = saveTag.func_74771_c("GrowthLevel");
        }
        this.updateFeedingLevels();
    }

    static {
        DAMAGE_BOOST = new AttributeModifier(UUID.fromString("70457CAB-AA09-4E1C-B44B-99DD4A2A836D"), "Feeding damage boost", 1.0, AttributeModifier.Operation.ADDITION);
    }
}

