/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.ai.goal;

import java.util.EnumSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.util.math.vector.Vector3d;

public class SpecialLeapAtTargetGoal
extends Goal {
    private static final float BASE_Y_VELOCITY = 0.4f;
    private final MobEntity mob;
    private final int infrequency;
    private final float minDistSq;
    private final float maxDistSq;
    private final float forwardPower;
    private final float upwardPower;
    private float momentum = 0.2f;
    private boolean canUseWhileMounted = false;
    private boolean ignoreFallDamage = false;
    private LivingEntity target;

    public SpecialLeapAtTargetGoal(MobEntity entity, int infreq, float minDist, float maxDist, float forward, float upward) {
        this.mob = entity;
        this.infrequency = infreq;
        this.minDistSq = minDist * minDist;
        this.maxDistSq = maxDist * maxDist;
        this.forwardPower = forward;
        this.upwardPower = upward;
        this.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
    }

    public SpecialLeapAtTargetGoal setMomentum(float value) {
        this.momentum = value;
        return this;
    }

    public SpecialLeapAtTargetGoal canUseWhileMounted() {
        this.canUseWhileMounted = true;
        return this;
    }

    public SpecialLeapAtTargetGoal ignoreFallDamage() {
        this.ignoreFallDamage = true;
        return this;
    }

    public boolean func_75250_a() {
        if (!this.mob.func_233570_aj_() || this.mob.func_184218_aH() || !this.canUseWhileMounted && this.mob.func_184207_aI()) {
            return false;
        }
        this.target = this.mob.func_70638_az();
        if (this.target == null || this.mob.func_70681_au().nextInt(this.infrequency) != 0) {
            return false;
        }
        double distanceSq = this.mob.func_70068_e((Entity)this.target);
        return distanceSq >= (double)this.minDistSq && distanceSq <= (double)this.maxDistSq;
    }

    public void func_75249_e() {
        Vector3d vLeap = new Vector3d(this.target.func_226277_ct_() - this.mob.func_226277_ct_(), 0.0, this.target.func_226281_cx_() - this.mob.func_226281_cx_()).func_72432_b().func_186678_a((double)this.forwardPower).func_178787_e(this.mob.func_213322_ci().func_186678_a((double)this.momentum));
        this.mob.func_213293_j(vLeap.field_72450_a, (double)(0.4f * this.upwardPower), vLeap.field_72449_c);
    }

    public boolean func_75253_b() {
        return !this.mob.func_233570_aj_() && !this.mob.func_184218_aH() && !this.mob.func_203005_aq() && !this.mob.func_180799_ab();
    }

    public void func_75246_d() {
        if (this.ignoreFallDamage) {
            this.mob.field_70143_R = 0.0f;
        }
    }
}

