/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.ai.goal;

import fathertoast.specialmobs.common.entity.SpecialMobData;
import fathertoast.specialmobs.common.entity.blaze._SpecialBlazeEntity;
import java.util.EnumSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;

public class SpecialBlazeAttackGoal
extends Goal {
    private final _SpecialBlazeEntity blaze;
    private int attackStep;
    private int attackTime;
    private int lastSeen;

    public SpecialBlazeAttackGoal(_SpecialBlazeEntity entity) {
        this.blaze = entity;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean func_75250_a() {
        LivingEntity target = this.blaze.func_70638_az();
        return target != null && target.func_70089_S() && this.blaze.func_213336_c(target);
    }

    public void func_75249_e() {
        this.attackStep = 0;
    }

    public void func_75251_c() {
        this.blaze.func_70844_e(false);
        this.lastSeen = 0;
    }

    public void func_75246_d() {
        --this.attackTime;
        LivingEntity target = this.blaze.func_70638_az();
        if (target == null) {
            return;
        }
        SpecialMobData<_SpecialBlazeEntity> data = this.blaze.getSpecialData();
        boolean canSee = this.blaze.func_70635_at().func_75522_a((Entity)target);
        this.lastSeen = canSee ? 0 : ++this.lastSeen;
        double distanceSqr = this.blaze.func_70068_e((Entity)target);
        float rangeSq = data.getRangedAttackMaxRange() * data.getRangedAttackMaxRange();
        if (distanceSqr < this.getAttackReachSqr(target)) {
            if (canSee && this.attackTime <= 0) {
                this.attackTime = 20;
                this.blaze.func_70652_k((Entity)target);
            }
            this.blaze.func_70605_aq().func_75642_a(target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), 1.0);
        } else if (distanceSqr < (double)rangeSq && canSee) {
            if (this.attackTime <= 0) {
                ++this.attackStep;
                if (this.attackStep == 1) {
                    this.attackTime = data.getRangedAttackCooldown();
                    this.blaze.func_70844_e(true);
                } else if (this.attackStep <= 1 + this.blaze.fireballBurstCount) {
                    this.attackTime = this.blaze.fireballBurstDelay;
                } else {
                    this.attackTime = data.getRangedAttackMaxCooldown() - data.getRangedAttackCooldown();
                    this.attackStep = 0;
                    this.blaze.func_70844_e(false);
                }
                if (this.attackStep > 1) {
                    this.blaze.func_82196_d(target, this.attackStep);
                }
            }
            this.blaze.func_70671_ap().func_75651_a((Entity)target, 10.0f, 10.0f);
        } else if (this.lastSeen < 5) {
            this.blaze.func_70605_aq().func_75642_a(target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), 1.0);
        }
        super.func_75246_d();
    }

    protected double getAttackReachSqr(LivingEntity target) {
        return this.blaze.func_213311_cf() * this.blaze.func_213311_cf() * 4.0f + target.func_213311_cf() + 2.0f;
    }
}

