/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.ai.goal;

import fathertoast.specialmobs.common.entity.MobHelper;
import fathertoast.specialmobs.common.entity.enderman.RunicEndermanEntity;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;

public class RunicEndermanBeamAttackGoal
extends Goal {
    private final RunicEndermanEntity mob;
    private final DamageSource beamDamageSource;
    private LivingEntity targetEntity;
    private Vector3d targetPos;
    private int attackTime;

    public RunicEndermanBeamAttackGoal(RunicEndermanEntity entity) {
        this.mob = entity;
        this.beamDamageSource = new EntityDamageSource(DamageSource.field_76376_m.func_76355_l(), (Entity)entity);
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean func_75250_a() {
        if (this.mob.func_184207_aI()) {
            return false;
        }
        LivingEntity target = this.mob.func_70638_az();
        if (target != null && target.func_70089_S() && this.mob.func_70635_at().func_75522_a((Entity)target) && this.mob.field_70173_aa % 8 == 0 && this.mob.func_70681_au().nextInt(10) == 0 && target.func_70068_e((Entity)this.mob) <= (double)(this.mob.getSpecialData().getRangedAttackMaxRange() * this.mob.getSpecialData().getRangedAttackMaxRange())) {
            this.targetEntity = target;
            this.updateTargetPos();
            this.attackTime = 0;
            this.mob.setBeamState(RunicEndermanEntity.BeamState.CHARGING);
            if (!this.mob.func_174814_R()) {
                this.mob.field_70170_p.func_184148_a(null, this.mob.func_226277_ct_(), this.mob.func_226280_cw_(), this.mob.func_226281_cx_(), SoundEvents.field_187532_aV, this.mob.func_184176_by(), 1.0f, 1.0f / (this.mob.func_70681_au().nextFloat() * 0.2f + 1.8f));
            }
            return true;
        }
        return false;
    }

    public boolean func_75253_b() {
        return (this.mob.getBeamState() == RunicEndermanEntity.BeamState.DAMAGING || this.targetEntity != null && this.targetEntity.func_70089_S()) && this.attackTime < this.mob.getSpecialData().getRangedAttackMaxCooldown();
    }

    public void func_75251_c() {
        this.targetEntity = null;
        this.targetPos = null;
        this.mob.setBeamState(RunicEndermanEntity.BeamState.OFF);
    }

    public void func_75246_d() {
        ++this.attackTime;
        switch (this.mob.getBeamState()) {
            case CHARGING: {
                this.chargingTick();
                break;
            }
            case DAMAGING: {
                this.damagingTick();
            }
        }
    }

    private void chargingTick() {
        this.mob.func_70671_ap().func_75650_a(this.targetPos.field_72450_a, this.targetPos.field_72448_b, this.targetPos.field_72449_c, 30.0f, (float)this.mob.func_70646_bf());
        if (this.attackTime >= this.mob.getSpecialData().getRangedAttackCooldown()) {
            this.mob.setBeamState(RunicEndermanEntity.BeamState.DAMAGING);
        }
    }

    private void damagingTick() {
        if (this.targetEntity != null) {
            this.updateTargetPos();
        }
        if (!this.mob.func_174814_R() && this.attackTime % 10 == 0) {
            this.mob.field_70170_p.func_184148_a(null, this.mob.func_226277_ct_(), this.mob.func_226280_cw_(), this.mob.func_226281_cx_(), SoundEvents.field_187532_aV, this.mob.func_184176_by(), 1.0f, 1.0f / (this.mob.func_70681_au().nextFloat() * 0.4f + 1.0f));
        }
        this.lookTowardTarget(1.7f * this.mob.getSpecialData().getRangedWalkSpeed());
        Vector3d viewVec = this.mob.func_70676_i(1.0f).func_186678_a(32.0);
        Vector3d beamStartPos = this.mob.func_174824_e(1.0f);
        Vector3d beamEndPos = beamStartPos.func_178787_e(viewVec);
        BlockRayTraceResult blockRayTrace = this.mob.field_70170_p.func_217299_a(new RayTraceContext(beamStartPos, beamEndPos, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this.mob));
        if (blockRayTrace.func_216346_c() != RayTraceResult.Type.MISS) {
            beamEndPos = blockRayTrace.func_216347_e();
        }
        List<Entity> hitEntities = this.rayTraceEntities(beamStartPos, beamEndPos, this.mob.func_174813_aQ().func_216361_a(viewVec).func_186662_g(1.0));
        for (Entity entity : hitEntities) {
            if (entity instanceof EndermanEntity || entity instanceof EnderDragonEntity) {
                if (this.mob.field_70173_aa % 10 != 0) continue;
                ((MobEntity)entity).func_70691_i(1.0f);
                continue;
            }
            if (!entity.func_70097_a(this.beamDamageSource, this.mob.getSpecialData().getRangedAttackDamage()) || !(entity instanceof LivingEntity)) continue;
            MobHelper.knockback((LivingEntity)entity, 1.0f, 1.0f, -viewVec.field_72450_a, -viewVec.field_72449_c, 1.0);
        }
    }

    private void updateTargetPos() {
        this.targetPos = new Vector3d(this.targetEntity.func_226277_ct_(), this.targetEntity.func_226283_e_(0.5), this.targetEntity.func_226281_cx_());
    }

    private void lookTowardTarget(float speed) {
        double dX = this.targetPos.field_72450_a - this.mob.func_226277_ct_();
        double dY = this.targetPos.field_72448_b - this.mob.func_226280_cw_();
        double dZ = this.targetPos.field_72449_c - this.mob.func_226281_cx_();
        double dH = MathHelper.func_76133_a((double)(dX * dX + dZ * dZ));
        float targetXRot = (float)MathHelper.func_181159_b((double)dY, (double)dH);
        float clampedXRot = (this.mob.field_70125_A + MathHelper.func_76131_a((float)MathHelper.func_203302_c((float)this.mob.field_70125_A, (float)(targetXRot * -57.295776f)), (float)(-speed), (float)speed)) / -57.295776f;
        double clampedDY = dH * (double)MathHelper.func_76126_a((float)clampedXRot) / (double)MathHelper.func_76134_b((float)clampedXRot);
        this.targetPos = this.targetPos.func_72441_c(0.0, clampedDY - dY, 0.0);
        this.mob.func_70671_ap().func_75650_a(this.targetPos.field_72450_a, this.targetPos.field_72448_b, this.targetPos.field_72449_c, speed, (float)this.mob.func_70646_bf());
    }

    private List<Entity> rayTraceEntities(Vector3d from, Vector3d to, AxisAlignedBB searchArea) {
        ArrayList<Entity> entitiesHit = new ArrayList<Entity>();
        for (Entity entity : this.mob.field_70170_p.func_175674_a((Entity)this.mob, searchArea, this::canBeamHitTarget)) {
            Optional hitPos = entity.func_174813_aQ().func_186662_g(0.3).func_216365_b(from, to);
            if (!hitPos.isPresent()) continue;
            entitiesHit.add(entity);
        }
        return entitiesHit;
    }

    private boolean canBeamHitTarget(@Nullable Entity entity) {
        return entity != null && !entity.func_175149_v() && entity.func_70089_S() && entity.func_70067_L() && !entity.func_184223_x((Entity)this.mob);
    }
}

