/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.ai.goal;

import fathertoast.specialmobs.common.entity.ISpecialMob;
import fathertoast.specialmobs.common.entity.MobHelper;
import fathertoast.specialmobs.common.entity.SpecialMobData;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.util.math.MathHelper;

public class PassiveRangedAttackGoal<T extends MobEntity & IRangedAttackMob>
extends Goal {
    private final T mob;
    private final float recoilPower;
    private int attackTime;

    public PassiveRangedAttackGoal(T entity) {
        this(entity, 0.0f);
    }

    public PassiveRangedAttackGoal(T entity, float recoil) {
        this.mob = entity;
        this.recoilPower = recoil;
    }

    public boolean func_75250_a() {
        return this.mob.func_70638_az() != null && ((ISpecialMob)this.mob).getSpecialData().getRangedAttackMaxRange() > 0.0f;
    }

    public void func_75246_d() {
        LivingEntity target = this.mob.func_70638_az();
        if (target == null) {
            return;
        }
        SpecialMobData data = ((ISpecialMob)this.mob).getSpecialData();
        double distSqr = target.func_70068_e(this.mob);
        if (distSqr <= (double)(data.getRangedAttackMaxRange() * data.getRangedAttackMaxRange()) && this.mob.func_70685_l((Entity)target)) {
            ++this.attackTime;
            if (this.attackTime >= data.getRangedAttackCooldown()) {
                this.attackTime = MathHelper.func_76141_d((float)((float)(data.getRangedAttackCooldown() - data.getRangedAttackMaxCooldown()) * MathHelper.func_76133_a((double)distSqr) / data.getRangedAttackMaxRange()));
                ((IRangedAttackMob)this.mob).func_82196_d(target, 1.0f);
                if (this.recoilPower != 0.0f) {
                    MobHelper.knockback(this.mob, this.recoilPower, 0.0f, target.func_226277_ct_() - this.mob.func_226277_ct_(), target.func_226281_cx_() - this.mob.func_226281_cx_(), 0.2);
                }
            }
        } else if (this.attackTime < 0) {
            ++this.attackTime;
        } else if (this.attackTime > 0) {
            --this.attackTime;
        }
    }
}

