/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.ai.goal;

import fathertoast.specialmobs.common.entity.ai.INinja;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SweetBerryBushBlock;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.state.Property;
import net.minecraft.state.properties.AttachFace;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;

public class NinjaGoal<T extends MobEntity>
extends Goal {
    private final T ninja;

    public NinjaGoal(T entity) {
        this.ninja = entity;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
    }

    public boolean func_75250_a() {
        if (((INinja)this.ninja).getHiddenDragon() == null || ((INinja)this.ninja).getHiddenDragon().func_185901_i() == BlockRenderType.INVISIBLE) {
            return false;
        }
        ArrayList players = new ArrayList(((MobEntity)this.ninja).field_70170_p.func_217369_A());
        for (PlayerEntity player : players) {
            float dZ;
            float dX = (float)(this.ninja.func_226277_ct_() - player.func_226277_ct_());
            float angleFromPlayer = (float)Math.atan2(dX, -(dZ = (float)(this.ninja.func_226281_cx_() - player.func_226281_cx_()))) * 180.0f / (float)Math.PI;
            if (!(Math.abs(angleFromPlayer - MathHelper.func_76142_g((float)player.field_70759_as)) > 90.0f)) continue;
            return true;
        }
        return false;
    }

    public void func_75249_e() {
        this.ninja.func_70661_as().func_75499_g();
        this.ninja.func_70066_B();
        this.ninja.func_225653_b_(Math.floor(this.ninja.func_226277_ct_()) + 0.5, Math.floor(this.ninja.func_226278_cu_()), Math.floor(this.ninja.func_226281_cx_()) + 0.5);
        this.ninja.func_213293_j(0.0, 0.0, 0.0);
        ((INinja)this.ninja).setCrouchingTiger(true);
    }

    public boolean func_75253_b() {
        return this.func_75250_a();
    }

    public boolean func_220685_C_() {
        return false;
    }

    public void func_75251_c() {
        ((INinja)this.ninja).setCrouchingTiger(false);
    }

    public static <T extends MobEntity> BlockState pickDisguise(T entity) {
        Random random = entity.func_70681_au();
        switch (random.nextInt(200)) {
            case 0: {
                return Blocks.field_150335_W.func_176223_P();
            }
            case 1: {
                return Blocks.field_196617_K.func_176223_P();
            }
            case 2: {
                return Blocks.field_150360_v.func_176223_P();
            }
            case 3: {
                return Blocks.field_196555_aI.func_176223_P();
            }
            case 4: {
                return Blocks.field_196642_W.func_176223_P();
            }
            case 5: {
                return NinjaGoal.randomRotation(Blocks.field_226905_ma_.func_176223_P(), random);
            }
            case 6: {
                return Blocks.field_150414_aQ.func_176223_P();
            }
            case 7: {
                return Blocks.field_150462_ai.func_176223_P();
            }
            case 8: {
                return NinjaGoal.randomRotation(Blocks.field_150460_al.func_176223_P(), random);
            }
            case 9: {
                return NinjaGoal.randomRotation(Blocks.field_150467_bQ.func_176223_P(), random);
            }
            case 10: {
                return Blocks.field_150382_bo.func_176223_P();
            }
            case 11: {
                return NinjaGoal.randomRotation((BlockState)Blocks.field_150442_at.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208158_K, (Comparable)AttachFace.FLOOR), random);
            }
            case 12: {
                return NinjaGoal.randomPottedFlower(random);
            }
            case 13: {
                return (BlockState)Blocks.field_222434_lW.func_176223_P().func_206870_a((Property)SweetBerryBushBlock.field_220125_a, (Comparable)Integer.valueOf(3));
            }
        }
        BlockPos posUnderFeet = entity.func_233580_cy_().func_177977_b();
        BlockState blockUnderFeet = entity.field_70170_p.func_180495_p(posUnderFeet);
        if (!blockUnderFeet.func_177230_c().isAir(blockUnderFeet, (IBlockReader)entity.field_70170_p, posUnderFeet)) {
            if (blockUnderFeet.func_203425_a(Blocks.field_150348_b) || blockUnderFeet.func_203425_a(Blocks.field_196696_di)) {
                switch (random.nextInt(30)) {
                    case 0: {
                        return Blocks.field_150338_P.func_176223_P();
                    }
                    case 1: {
                        return Blocks.field_150337_Q.func_176223_P();
                    }
                    case 2: {
                        return Blocks.field_150435_aG.func_176223_P();
                    }
                    case 3: {
                        return Blocks.field_150351_n.func_176223_P();
                    }
                    case 4: {
                        return Blocks.field_150365_q.func_176223_P();
                    }
                    case 5: {
                        return Blocks.field_150366_p.func_176223_P();
                    }
                    case 6: {
                        return Blocks.field_150369_x.func_176223_P();
                    }
                    case 7: {
                        return Blocks.field_150352_o.func_176223_P();
                    }
                    case 8: {
                        return Blocks.field_150450_ax.func_176223_P();
                    }
                    case 9: {
                        return Blocks.field_150482_ag.func_176223_P();
                    }
                    case 10: {
                        return Blocks.field_150412_bA.func_176223_P();
                    }
                    case 11: {
                        return Blocks.field_150341_Y.func_176223_P();
                    }
                }
            } else if (blockUnderFeet.func_203425_a(Blocks.field_150349_c) || blockUnderFeet.func_203425_a(Blocks.field_150346_d) || blockUnderFeet.func_203425_a(Blocks.field_196661_l)) {
                switch (random.nextInt(20)) {
                    case 0: {
                        return blockUnderFeet;
                    }
                    case 1: {
                        return Blocks.field_196617_K.func_176223_P();
                    }
                    case 2: {
                        return Blocks.field_196642_W.func_176223_P();
                    }
                    case 3: {
                        return Blocks.field_150423_aK.func_176223_P();
                    }
                    case 4: {
                        return Blocks.field_150440_ba.func_176223_P();
                    }
                    case 5: {
                        return Blocks.field_196804_gh.func_176223_P();
                    }
                    case 6: {
                        return Blocks.field_196554_aH.func_176223_P();
                    }
                    case 7: {
                        return NinjaGoal.randomRotation(Blocks.field_226905_ma_.func_176223_P(), random);
                    }
                    case 8: {
                        return NinjaGoal.randomFlower(random);
                    }
                    case 9: {
                        return NinjaGoal.randomPottedFlower(random);
                    }
                    case 10: {
                        return NinjaGoal.randomPottedPlant(random);
                    }
                }
            } else if (blockUnderFeet.func_203425_a(Blocks.field_150354_m) || blockUnderFeet.func_203425_a(Blocks.field_196611_F) || blockUnderFeet.func_203425_a(Blocks.field_150322_A) || blockUnderFeet.func_203425_a(Blocks.field_180395_cM)) {
                switch (random.nextInt(5)) {
                    case 0: {
                        return Blocks.field_150434_aF.func_176223_P();
                    }
                    case 1: {
                        return Blocks.field_196555_aI.func_176223_P();
                    }
                    case 2: {
                        return NinjaGoal.randomPottedDesertPlant(random);
                    }
                }
            } else if (blockUnderFeet.func_203425_a(Blocks.field_150424_aL) || blockUnderFeet.func_203425_a(Blocks.field_196653_dH) || blockUnderFeet.func_203425_a(Blocks.field_150425_aM) || blockUnderFeet.func_203425_a(Blocks.field_235336_cN_) || blockUnderFeet.func_203425_a(Blocks.field_235381_mu_) || blockUnderFeet.func_203425_a(Blocks.field_235372_ml_)) {
                switch (random.nextInt(25)) {
                    case 0: {
                        return blockUnderFeet;
                    }
                    case 1: {
                        return Blocks.field_150351_n.func_176223_P();
                    }
                    case 2: {
                        return Blocks.field_196766_fg.func_176223_P();
                    }
                    case 3: {
                        return Blocks.field_235334_I_.func_176223_P();
                    }
                    case 4: {
                        return Blocks.field_235398_nh_.func_176223_P();
                    }
                    case 5: {
                        return Blocks.field_150338_P.func_176223_P();
                    }
                    case 6: {
                        return Blocks.field_150337_Q.func_176223_P();
                    }
                    case 7: {
                        return Blocks.field_235377_mq_.func_176223_P();
                    }
                    case 8: {
                        return Blocks.field_235368_mh_.func_176223_P();
                    }
                    case 9: {
                        return Blocks.field_235343_mB_.func_176223_P();
                    }
                    case 10: {
                        return Blocks.field_235375_mo_.func_176223_P();
                    }
                    case 11: {
                        return Blocks.field_235382_mv_.func_176223_P();
                    }
                    case 12: {
                        return Blocks.field_235373_mm_.func_176223_P();
                    }
                    case 13: {
                        return NinjaGoal.randomPottedNetherThing(random);
                    }
                }
            } else if (blockUnderFeet.func_203425_a(Blocks.field_150377_bs) || blockUnderFeet.func_203425_a(Blocks.field_196806_hJ) || blockUnderFeet.func_203425_a(Blocks.field_185767_cT)) {
                switch (random.nextInt(10)) {
                    case 0: {
                        return Blocks.field_185765_cR.func_176223_P();
                    }
                    case 1: {
                        return Blocks.field_185768_cU.func_176223_P();
                    }
                    case 2: {
                        return NinjaGoal.randomPottedEndThing(random);
                    }
                }
            }
        }
        BlockPos.Mutable randPos = new BlockPos.Mutable();
        for (int i = 0; i < 16; ++i) {
            randPos.func_181079_c(posUnderFeet.func_177958_n() + random.nextInt(17) - 8, posUnderFeet.func_177956_o() + random.nextInt(5) - 2, posUnderFeet.func_177952_p() + random.nextInt(17) - 8);
            BlockState randBlock = entity.field_70170_p.func_180495_p((BlockPos)randPos);
            if (randBlock.func_185901_i() != BlockRenderType.MODEL) continue;
            return randBlock;
        }
        return Blocks.field_196617_K.func_176223_P();
    }

    private static BlockState randomRotation(BlockState block, Random random) {
        return (BlockState)block.func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)Direction.Plane.HORIZONTAL.func_179518_a(random));
    }

    private static BlockState randomFlower(Random random) {
        return ((Block)BlockTags.field_219746_E.func_205596_a(random)).func_176223_P();
    }

    private static BlockState randomPottedFlower(Random random) {
        switch (random.nextInt(12)) {
            case 0: {
                return Blocks.field_196744_er.func_176223_P();
            }
            case 1: {
                return Blocks.field_196726_ei.func_176223_P();
            }
            case 2: {
                return Blocks.field_196728_ej.func_176223_P();
            }
            case 3: {
                return Blocks.field_196730_ek.func_176223_P();
            }
            case 4: {
                return Blocks.field_196732_el.func_176223_P();
            }
            case 5: {
                return Blocks.field_196734_em.func_176223_P();
            }
            case 6: {
                return Blocks.field_196736_en.func_176223_P();
            }
            case 7: {
                return Blocks.field_196738_eo.func_176223_P();
            }
            case 8: {
                return Blocks.field_196740_ep.func_176223_P();
            }
            case 9: {
                return Blocks.field_196742_eq.func_176223_P();
            }
            case 10: {
                return Blocks.field_222398_eF.func_176223_P();
            }
        }
        return Blocks.field_222399_eG.func_176223_P();
    }

    private static BlockState randomPottedPlant(Random random) {
        switch (random.nextInt(8)) {
            case 0: {
                return Blocks.field_196746_es.func_176223_P();
            }
            case 1: {
                return Blocks.field_196748_et.func_176223_P();
            }
            case 2: {
                return Blocks.field_196750_eu.func_176223_P();
            }
            case 3: {
                return Blocks.field_196752_ev.func_176223_P();
            }
            case 4: {
                return Blocks.field_196754_ew.func_176223_P();
            }
            case 5: {
                return Blocks.field_196755_ex.func_176223_P();
            }
            case 6: {
                return Blocks.field_196683_eB.func_176223_P();
            }
        }
        return Blocks.field_222406_kR.func_176223_P();
    }

    private static BlockState randomPottedDesertPlant(Random random) {
        switch (random.nextInt(2)) {
            case 0: {
                return Blocks.field_196681_eA.func_176223_P();
            }
        }
        return Blocks.field_196685_eC.func_176223_P();
    }

    private static BlockState randomPottedNetherThing(Random random) {
        switch (random.nextInt(7)) {
            case 0: {
                return Blocks.field_222400_eH.func_176223_P();
            }
            case 1: {
                return Blocks.field_196756_ey.func_176223_P();
            }
            case 2: {
                return Blocks.field_196757_ez.func_176223_P();
            }
            case 3: {
                return Blocks.field_235401_nk_.func_176223_P();
            }
            case 4: {
                return Blocks.field_235402_nl_.func_176223_P();
            }
            case 5: {
                return Blocks.field_235403_nm_.func_176223_P();
            }
        }
        return Blocks.field_235404_nn_.func_176223_P();
    }

    private static BlockState randomPottedEndThing(Random random) {
        switch (random.nextInt(5)) {
            case 0: {
                return Blocks.field_222400_eH.func_176223_P();
            }
            case 1: {
                return Blocks.field_196730_ek.func_176223_P();
            }
            case 2: {
                return Blocks.field_196732_el.func_176223_P();
            }
            case 3: {
                return Blocks.field_196742_eq.func_176223_P();
            }
        }
        return Blocks.field_222399_eG.func_176223_P();
    }
}

