/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.ai.goal;

import fathertoast.specialmobs.common.entity.MobHelper;
import fathertoast.specialmobs.common.entity.ai.IAmmoUser;
import java.util.EnumSet;
import java.util.List;
import java.util.function.BiPredicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class ChargeCreeperGoal<T extends MobEntity>
extends Goal {
    private final BiPredicate<T, ? super CreeperEntity> targetPredicate;
    private final T madman;
    private final double movementSpeed;
    private final double targetRange;
    private CreeperEntity creeper;
    private int pathUpdateCooldown;
    private Vector3d pathTarget = Vector3d.field_186680_a;
    private boolean canUseWhileMounted = false;

    public ChargeCreeperGoal(T madman, double movementSpeed, double targetRange, BiPredicate<T, ? super CreeperEntity> targetPredicate) {
        this.madman = madman;
        this.movementSpeed = movementSpeed;
        this.targetRange = targetRange;
        this.targetPredicate = targetPredicate;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
    }

    public ChargeCreeperGoal<T> canUseWhileMounted() {
        this.canUseWhileMounted = true;
        return this;
    }

    public boolean func_75250_a() {
        if (!((IAmmoUser)this.madman).hasAmmo() || this.madman.func_184218_aH() || !this.canUseWhileMounted && this.madman.func_184207_aI()) {
            return false;
        }
        this.findCreeper();
        if (this.creeper == null) {
            return false;
        }
        this.madman.func_70661_as().func_75497_a((Entity)this.creeper, this.movementSpeed);
        this.pathTarget = this.creeper.func_213303_ch();
        this.pathUpdateCooldown = 4 + this.madman.func_70681_au().nextInt(7);
        return this.madman.func_70661_as().func_75505_d() != null;
    }

    private void findCreeper() {
        World world = ((MobEntity)this.madman).field_70170_p;
        List nearbyCreepers = world.func_225316_b(CreeperEntity.class, this.madman.func_174813_aQ().func_186662_g(this.targetRange), null);
        if (!nearbyCreepers.isEmpty()) {
            for (CreeperEntity creeper : nearbyCreepers) {
                if (!this.targetPredicate.test(this.madman, (CreeperEntity)creeper)) continue;
                this.creeper = creeper;
                break;
            }
        }
    }

    public boolean func_75253_b() {
        return !this.madman.func_184218_aH() && (this.canUseWhileMounted || this.madman.func_184207_aI()) && this.creeper != null && this.targetPredicate.test(this.madman, (CreeperEntity)this.creeper);
    }

    public void func_75246_d() {
        if (this.creeper == null) {
            return;
        }
        double distanceSq = this.madman.func_70068_e((Entity)this.creeper);
        --this.pathUpdateCooldown;
        if (this.pathUpdateCooldown <= 0 && (this.creeper.func_195048_a(this.pathTarget) >= 1.0 || this.madman.func_70681_au().nextFloat() < 0.05f)) {
            this.pathUpdateCooldown = 4 + this.madman.func_70681_au().nextInt(7);
            if (distanceSq > 1024.0) {
                this.pathUpdateCooldown += 10;
            } else if (distanceSq > 256.0) {
                this.pathUpdateCooldown += 5;
            }
            if (!this.madman.func_70661_as().func_75497_a((Entity)this.creeper, this.movementSpeed)) {
                this.pathUpdateCooldown += 15;
            }
            this.pathTarget = this.creeper.func_213303_ch();
        }
        this.madman.func_70671_ap().func_75651_a((Entity)this.creeper, 30.0f, 30.0f);
        if (distanceSq < 2.5) {
            if (((IAmmoUser)this.madman).hasAmmo()) {
                ((IAmmoUser)this.madman).consumeAmmo();
                MobHelper.charge(this.creeper);
                ((MobEntity)this.madman).field_70170_p.func_184148_a(null, this.creeper.func_226277_ct_(), this.creeper.func_226278_cu_(), this.creeper.func_226281_cx_(), SoundEvents.field_226128_ac_, SoundCategory.HOSTILE, 0.9f, 1.0f);
            }
            this.creeper = null;
        }
    }
}

