/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.ai.goal;

import fathertoast.specialmobs.common.entity.ISpecialMob;
import fathertoast.specialmobs.common.entity.SpecialMobData;
import fathertoast.specialmobs.common.entity.ai.IAngler;
import fathertoast.specialmobs.common.entity.projectile.SpecialFishingBobberEntity;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.util.SoundEvents;

public class AnglerGoal<T extends MobEntity & IAngler>
extends Goal {
    private final T mob;
    private SpecialFishingBobberEntity bobber;
    private int castTime;

    public AnglerGoal(T entity) {
        this.mob = entity;
    }

    private void setBobber(@Nullable SpecialFishingBobberEntity newBobber) {
        if (this.bobber != null) {
            this.bobber.func_70106_y();
        }
        this.bobber = newBobber;
        ((IAngler)this.mob).setLineOut(newBobber != null);
    }

    public boolean func_75250_a() {
        return this.mob.func_70638_az() != null && ((ISpecialMob)this.mob).getSpecialData().getRangedAttackMaxRange() > 4.0f;
    }

    public void func_75251_c() {
        this.setBobber(null);
        this.castTime = 0;
    }

    public void func_75246_d() {
        LivingEntity target = this.mob.func_70638_az();
        if (target == null) {
            return;
        }
        if (this.bobber != null && !this.bobber.func_70089_S()) {
            this.bobber = null;
            ((IAngler)this.mob).setLineOut(false);
        }
        SpecialMobData data = ((ISpecialMob)this.mob).getSpecialData();
        double distSqr = target.func_70068_e(this.mob);
        if (distSqr > 16.0 && distSqr <= (double)(data.getRangedAttackMaxRange() * data.getRangedAttackMaxRange()) && this.mob.func_70685_l((Entity)target)) {
            ++this.castTime;
            if (this.castTime >= data.getRangedAttackCooldown() && this.mob.func_70681_au().nextInt(5) == 0) {
                this.castTime = 0;
                SpecialFishingBobberEntity newBobber = new SpecialFishingBobberEntity((LivingEntity)this.mob, target);
                this.mob.func_184185_a(SoundEvents.field_187612_G, 1.0f, 0.4f / (this.mob.func_70681_au().nextFloat() * 0.4f + 0.8f));
                ((MobEntity)this.mob).field_70170_p.func_217376_c((Entity)newBobber);
                this.setBobber(newBobber);
            }
        } else if (this.castTime > 0) {
            --this.castTime;
        }
    }
}

