/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.ai.goal;

import java.util.EnumSet;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;

public class AmphibiousGoToWaterGoal
extends Goal {
    private final MobEntity mob;
    private final double speedModifier;
    private boolean disableAtNight = true;
    private double wantedX;
    private double wantedY;
    private double wantedZ;

    public AmphibiousGoToWaterGoal(MobEntity entity, double speed) {
        this.mob = entity;
        this.speedModifier = speed;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
    }

    public AmphibiousGoToWaterGoal alwaysEnabled() {
        this.disableAtNight = false;
        return this;
    }

    public boolean func_75250_a() {
        if (this.disableAtNight && !this.mob.field_70170_p.func_72935_r() || this.mob.func_70090_H()) {
            return false;
        }
        Vector3d targetPos = this.findWaterPos();
        if (targetPos == null) {
            return false;
        }
        this.wantedX = targetPos.field_72450_a;
        this.wantedY = targetPos.field_72448_b;
        this.wantedZ = targetPos.field_72449_c;
        return true;
    }

    public boolean func_75253_b() {
        return !this.mob.func_70661_as().func_75500_f();
    }

    public void func_75249_e() {
        this.mob.func_70661_as().func_75492_a(this.wantedX, this.wantedY, this.wantedZ, this.speedModifier);
    }

    @Nullable
    private Vector3d findWaterPos() {
        Random random = this.mob.func_70681_au();
        BlockPos origin = this.mob.func_233580_cy_();
        for (int i = 0; i < 10; ++i) {
            BlockPos target = origin.func_177982_a(random.nextInt(20) - 10, 2 - random.nextInt(8), random.nextInt(20) - 10);
            if (!this.mob.field_70170_p.func_180495_p(target).func_203425_a(Blocks.field_150355_j)) continue;
            return Vector3d.func_237492_c_((Vector3i)target);
        }
        return null;
    }
}

