/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.ai;

import fathertoast.specialmobs.common.core.SpecialMobs;
import fathertoast.specialmobs.common.entity.ai.goal.SpecialHurtByTargetGoal;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.GoalSelector;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.PrioritizedGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;

public final class AIHelper {
    public static void insertGoal(GoalSelector ai, int priority, Goal goal) {
        for (PrioritizedGoal task : new ArrayList(ai.field_220892_d)) {
            if (task.func_220770_h() < priority) continue;
            ++task.field_220775_b;
        }
        ai.func_75776_a(priority, goal);
    }

    public static void insertGoalReverse(GoalSelector ai, int priority, Goal goal) {
        for (PrioritizedGoal task : new ArrayList(ai.field_220892_d)) {
            if (task.func_220770_h() > priority) continue;
            --task.field_220775_b;
        }
        ai.func_75776_a(priority, goal);
    }

    public static void removeGoals(GoalSelector ai, int priority) {
        for (PrioritizedGoal task : new ArrayList(ai.field_220892_d)) {
            if (task.func_220770_h() != priority) continue;
            ai.func_85156_a(task.func_220772_j());
        }
    }

    public static void removeGoals(GoalSelector ai, Class<? extends Goal> goalType) {
        for (PrioritizedGoal task : new ArrayList(ai.field_220892_d)) {
            if (!task.func_220772_j().getClass().equals(goalType)) continue;
            ai.func_85156_a(task.func_220772_j());
        }
    }

    @Nullable
    public static Goal getGoal(GoalSelector ai, int priority) {
        for (PrioritizedGoal task : new ArrayList(ai.field_220892_d)) {
            if (task.func_220770_h() != priority) continue;
            return task.func_220772_j();
        }
        SpecialMobs.LOG.warn("Attempted to get '{}'-priority goal, but none exists!", (Object)priority);
        return null;
    }

    @Nullable
    public static Goal getGoal(GoalSelector ai, Class<? extends Goal> goalType) {
        for (PrioritizedGoal task : new ArrayList(ai.field_220892_d)) {
            if (!task.func_220772_j().getClass().equals(goalType)) continue;
            return task.func_220772_j();
        }
        SpecialMobs.LOG.warn("Attempted to get '{}' goal, but none exists!", (Object)goalType.getSimpleName());
        return null;
    }

    public static void replaceWaterAvoidingRandomWalking(CreatureEntity entity, double speedModifier) {
        for (PrioritizedGoal task : new ArrayList(entity.field_70714_bg.field_220892_d)) {
            if (!(task.func_220772_j() instanceof WaterAvoidingRandomWalkingGoal)) continue;
            int priority = task.func_220770_h();
            entity.field_70714_bg.func_85156_a(task.func_220772_j());
            entity.field_70714_bg.func_75776_a(priority, (Goal)new RandomWalkingGoal(entity, speedModifier));
            return;
        }
        SpecialMobs.LOG.warn("Attempted to replace random walking goal for {}, but none exists!", (Object)entity.getClass().getSimpleName());
    }

    public static void replaceHurtByTarget(CreatureEntity entity, SpecialHurtByTargetGoal replacement) {
        for (PrioritizedGoal task : new ArrayList(entity.field_70715_bh.field_220892_d)) {
            if (!(task.func_220772_j() instanceof HurtByTargetGoal)) continue;
            int priority = task.func_220770_h();
            entity.field_70715_bh.func_85156_a(task.func_220772_j());
            entity.field_70715_bh.func_75776_a(priority, (Goal)replacement);
            return;
        }
        SpecialMobs.LOG.warn("Attempted to replace hurt by target goal for {}, but none exists!", (Object)entity.getClass().getSimpleName());
    }
}

