/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity;

import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.config.Config;
import fathertoast.specialmobs.common.config.family.FamilyConfig;
import fathertoast.specialmobs.common.config.species.SpeciesConfig;
import fathertoast.specialmobs.common.config.util.RegistryEntryList;
import fathertoast.specialmobs.common.core.SpecialMobs;
import fathertoast.specialmobs.common.entity.ISpecialMob;
import fathertoast.specialmobs.common.util.References;
import java.util.Collection;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class SpecialMobData<T extends LivingEntity> {
    private final T theEntity;
    private final DataParameter<Float> renderScale;
    private int healTimeMax;
    private int healTime;
    private float fallDamageMultiplier;
    private boolean isImmuneToFire;
    private boolean isImmuneToBurning;
    private boolean canBreatheInWater;
    private boolean ignoreWaterPush;
    private boolean isDamagedByWater;
    private boolean allowLeashing;
    private boolean ignorePressurePlates;
    private final HashSet<Block> immuneToStickyBlocks = new HashSet();
    private final HashSet<Effect> immuneToPotions = new HashSet();
    private float rangedAttackDamage;
    private float rangedAttackSpread;
    private float rangedWalkSpeed;
    private int rangedAttackCooldown;
    private int rangedAttackMaxCooldown;
    private float rangedAttackMaxRange;

    public static CompoundNBT getSaveLocation(CompoundNBT tag) {
        CompoundNBT forgeTag;
        if (!tag.func_150297_b("ForgeData", References.NBT_TYPE_COMPOUND)) {
            tag.func_218657_a("ForgeData", (INBT)new CompoundNBT());
        }
        if (!(forgeTag = tag.func_74775_l("ForgeData")).func_150297_b("SpecialMobsData", References.NBT_TYPE_COMPOUND)) {
            forgeTag.func_218657_a("SpecialMobsData", (INBT)new CompoundNBT());
        }
        return forgeTag.func_74775_l("SpecialMobsData");
    }

    public SpecialMobData(T entity, DataParameter<Float> scale) {
        this.theEntity = entity;
        this.renderScale = scale;
        entity.func_184212_Q().func_187214_a(this.renderScale, (Object)Float.valueOf(this.nextScale()));
        SpeciesConfig.General config = ((ISpecialMob)this.theEntity).getSpecies().config.GENERAL;
        this.setRangedAttackDamage(config.rangedAttackDamage == null ? -1.0f : (float)config.rangedAttackDamage.get());
        this.setRangedAttackSpread(config.rangedAttackSpread == null ? -1.0f : (float)config.rangedAttackSpread.get());
        this.setRangedWalkSpeed(config.rangedWalkSpeed == null ? -1.0f : (float)config.rangedWalkSpeed.get());
        this.setRangedAttackCooldown(config.rangedAttackCooldown == null ? -1 : config.rangedAttackCooldown.get());
        this.setRangedAttackMaxCooldown(config.rangedAttackMaxCooldown == null ? -1 : config.rangedAttackMaxCooldown.get());
        this.setRangedAttackMaxRange(config.rangedAttackMaxRange == null ? -1.0f : (float)config.rangedAttackMaxRange.get());
    }

    public void initialize() {
        SpeciesConfig.General config = ((ISpecialMob)this.theEntity).getSpecies().config.GENERAL;
        ((ISpecialMob)this.theEntity).setExperience(config.experience.get());
        this.setRegenerationTime(config.healTime.get());
        this.setFallDamageMultiplier((float)config.fallDamageMultiplier.get());
        this.setImmuneToFire(config.isImmuneToFire.get());
        this.setImmuneToBurning(config.isImmuneToBurning.get());
        this.setCanBreatheInWater(config.canBreatheInWater.get());
        this.setIgnoreWaterPush(config.ignoreWaterPush.get());
        this.setDamagedByWater(config.isDamagedByWater.get());
        this.setAllowLeashing(config.allowLeashing.get());
        this.setIgnorePressurePlates(config.ignorePressurePlates.get());
        this.addStickyBlockImmunity(((RegistryEntryList)config.immuneToStickyBlocks.get()).getEntries());
        this.addPotionImmunity(((RegistryEntryList)config.immuneToPotions.get()).getEntries());
    }

    public void tick() {
        if (!((LivingEntity)this.theEntity).field_70170_p.field_72995_K && this.theEntity.func_70089_S() && this.healTimeMax > 0 && ++this.healTime >= this.healTimeMax) {
            this.healTime = 0;
            this.theEntity.func_70691_i(1.0f);
        }
    }

    public ResourceLocation getTexture() {
        return ((ISpecialMob)this.theEntity).getSpecies().bestiaryInfo.texture;
    }

    @Nullable
    public ResourceLocation getTextureEyes() {
        return ((ISpecialMob)this.theEntity).getSpecies().bestiaryInfo.eyesTexture;
    }

    @Nullable
    public ResourceLocation getTextureOverlay() {
        return ((ISpecialMob)this.theEntity).getSpecies().bestiaryInfo.overlayTexture;
    }

    public float getRenderScale() {
        return ((Float)this.theEntity.func_184212_Q().func_187225_a(this.renderScale)).floatValue();
    }

    public void setRenderScale(float scale) {
        if (!((LivingEntity)this.theEntity).field_70170_p.field_72995_K) {
            this.theEntity.func_184212_Q().func_187227_b(this.renderScale, (Object)Float.valueOf(scale));
        }
    }

    public float getHeightScale() {
        return ((ISpecialMob)this.theEntity).getSpecies().getHeightScale();
    }

    public float getHeightScaleByAge() {
        return this.getHeightScale() * (this.theEntity.func_70631_g_() ? 0.53448f : 1.0f);
    }

    private float getBaseScale() {
        return ((ISpecialMob)this.theEntity).getSpecies().bestiaryInfo.baseScale;
    }

    private float nextScale() {
        if (((LivingEntity)this.theEntity).field_70170_p == null || ((LivingEntity)this.theEntity).field_70170_p.func_201670_d()) {
            return this.getBaseScale();
        }
        MobFamily.Species species = ((ISpecialMob)this.theEntity).getSpecies();
        double randomScaling = species.config.GENERAL.randomScaling.get() >= 0.0 ? species.config.GENERAL.randomScaling.get() : (((FamilyConfig)species.family.config).GENERAL.familyRandomScaling.get() >= 0.0 ? ((FamilyConfig)species.family.config).GENERAL.familyRandomScaling.get() : Config.MAIN.GENERAL.masterRandomScaling.get());
        return randomScaling <= 0.0 ? this.getBaseScale() : this.getBaseScale() * (1.0f + (this.theEntity.func_70681_au().nextFloat() - 0.5f) * 2.0f * (float)randomScaling);
    }

    private void setRegenerationTime(int ticks) {
        this.healTimeMax = ticks;
    }

    public float getFallDamageMultiplier() {
        return this.fallDamageMultiplier;
    }

    private void setFallDamageMultiplier(float value) {
        this.fallDamageMultiplier = value;
    }

    public boolean isImmuneToFire() {
        return this.isImmuneToFire;
    }

    private void setImmuneToFire(boolean value) {
        this.isImmuneToFire = value;
        if (value) {
            ((ISpecialMob)this.theEntity).setSpecialPathfindingMalus(PathNodeType.LAVA, PathNodeType.WATER.func_186289_a());
            ((ISpecialMob)this.theEntity).setSpecialPathfindingMalus(PathNodeType.DANGER_FIRE, PathNodeType.OPEN.func_186289_a());
            ((ISpecialMob)this.theEntity).setSpecialPathfindingMalus(PathNodeType.DAMAGE_FIRE, PathNodeType.OPEN.func_186289_a());
        } else {
            ((ISpecialMob)this.theEntity).setSpecialPathfindingMalus(PathNodeType.LAVA, PathNodeType.LAVA.func_186289_a());
            ((ISpecialMob)this.theEntity).setSpecialPathfindingMalus(PathNodeType.DANGER_FIRE, PathNodeType.DANGER_FIRE.func_186289_a());
            ((ISpecialMob)this.theEntity).setSpecialPathfindingMalus(PathNodeType.DAMAGE_FIRE, PathNodeType.DAMAGE_FIRE.func_186289_a());
        }
    }

    public boolean isImmuneToBurning() {
        return this.isImmuneToBurning;
    }

    private void setImmuneToBurning(boolean value) {
        this.theEntity.func_70066_B();
        this.isImmuneToBurning = value;
        if (value) {
            ((ISpecialMob)this.theEntity).setSpecialPathfindingMalus(PathNodeType.DANGER_FIRE, PathNodeType.OPEN.func_186289_a());
            ((ISpecialMob)this.theEntity).setSpecialPathfindingMalus(PathNodeType.DAMAGE_FIRE, PathNodeType.DANGER_FIRE.func_186289_a());
        } else {
            ((ISpecialMob)this.theEntity).setSpecialPathfindingMalus(PathNodeType.DANGER_FIRE, PathNodeType.DANGER_FIRE.func_186289_a());
            ((ISpecialMob)this.theEntity).setSpecialPathfindingMalus(PathNodeType.DAMAGE_FIRE, PathNodeType.DAMAGE_FIRE.func_186289_a());
        }
    }

    public boolean allowLeashing() {
        return this.allowLeashing;
    }

    private void setAllowLeashing(boolean value) {
        this.allowLeashing = value;
    }

    public boolean ignorePressurePlates() {
        return this.ignorePressurePlates;
    }

    private void setIgnorePressurePlates(boolean value) {
        this.ignorePressurePlates = value;
    }

    public boolean canBreatheInWater() {
        return this.canBreatheInWater;
    }

    private void setCanBreatheInWater(boolean value) {
        this.canBreatheInWater = value;
    }

    public boolean ignoreWaterPush() {
        return this.ignoreWaterPush;
    }

    private void setIgnoreWaterPush(boolean value) {
        this.ignoreWaterPush = value;
    }

    public boolean isDamagedByWater() {
        return this.isDamagedByWater;
    }

    private void setDamagedByWater(boolean value) {
        this.isDamagedByWater = value;
        ((ISpecialMob)this.theEntity).setSpecialPathfindingMalus(PathNodeType.WATER, value ? PathNodeType.LAVA.func_186289_a() : PathNodeType.WATER.func_186289_a());
    }

    public boolean canBeStuckIn(@Nullable BlockState block) {
        return block != null && !this.immuneToStickyBlocks.contains(block.func_177230_c());
    }

    private void addStickyBlockImmunity(Collection<Block> blocks) {
        this.immuneToStickyBlocks.addAll(blocks);
    }

    public boolean isPotionApplicable(EffectInstance effect) {
        PotionEvent.PotionApplicableEvent event = new PotionEvent.PotionApplicableEvent(this.theEntity, effect);
        MinecraftForge.EVENT_BUS.post((Event)event);
        switch (event.getResult()) {
            case DENY: {
                return false;
            }
            case ALLOW: {
                return true;
            }
        }
        return !this.immuneToPotions.contains(effect.func_188419_a());
    }

    private void addPotionImmunity(Collection<Effect> effects) {
        this.immuneToPotions.addAll(effects);
    }

    public float getRangedAttackDamage() {
        return this.rangedAttackDamage;
    }

    public void setRangedAttackDamage(float value) {
        this.rangedAttackDamage = value;
    }

    public float getRangedAttackSpread() {
        return this.rangedAttackSpread;
    }

    public void setRangedAttackSpread(float value) {
        this.rangedAttackSpread = value;
    }

    public float getRangedWalkSpeed() {
        return this.rangedWalkSpeed;
    }

    public void setRangedWalkSpeed(float value) {
        this.rangedWalkSpeed = value;
    }

    public int getRangedAttackCooldown() {
        return this.rangedAttackCooldown;
    }

    public void setRangedAttackCooldown(int value) {
        this.rangedAttackCooldown = value;
    }

    public int getRangedAttackMaxCooldown() {
        return this.rangedAttackMaxCooldown;
    }

    public void setRangedAttackMaxCooldown(int value) {
        this.rangedAttackMaxCooldown = value;
    }

    public float getRangedAttackMaxRange() {
        return this.rangedAttackMaxRange;
    }

    public void setRangedAttackMaxRange(float value) {
        this.rangedAttackMaxRange = value;
    }

    public void disableRangedAttack() {
        this.setRangedAttackMaxRange(0.0f);
    }

    public void writeToNBT(CompoundNBT tag) {
        tag.func_74776_a("RenderScale", this.getRenderScale());
        tag.func_74768_a("Experience", ((ISpecialMob)this.theEntity).getExperience());
        tag.func_74774_a("Regeneration", (byte)this.healTimeMax);
        tag.func_74776_a("FallMulti", this.getFallDamageMultiplier());
        tag.func_74757_a("FireImmune", this.isImmuneToFire());
        tag.func_74757_a("BurningImmune", this.isImmuneToBurning());
        tag.func_74757_a("Leashable", this.allowLeashing());
        tag.func_74757_a("UnderPressure", this.ignorePressurePlates());
        tag.func_74757_a("DrownImmune", this.canBreatheInWater());
        tag.func_74757_a("WaterPushImmune", this.ignoreWaterPush());
        tag.func_74757_a("WaterDamage", this.isDamagedByWater());
        ListNBT stickyBlocksTag = new ListNBT();
        for (Block block : this.immuneToStickyBlocks) {
            ResourceLocation regKey = ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)block);
            if (regKey == null) continue;
            stickyBlocksTag.add((Object)StringNBT.func_229705_a_((String)SpecialMobs.toString(regKey)));
        }
        tag.func_218657_a("StickyImmune", (INBT)stickyBlocksTag);
        ListNBT potionsTag = new ListNBT();
        for (Effect effect : this.immuneToPotions) {
            ResourceLocation regKey = ForgeRegistries.POTIONS.getKey((IForgeRegistryEntry)effect);
            if (regKey == null) continue;
            potionsTag.add((Object)StringNBT.func_229705_a_((String)SpecialMobs.toString(regKey)));
        }
        tag.func_218657_a("PotionImmune", (INBT)potionsTag);
        if (this.getRangedAttackDamage() >= 0.0f) {
            tag.func_74776_a("RangedDamage", this.getRangedAttackDamage());
        }
        if (this.getRangedAttackSpread() >= 0.0f) {
            tag.func_74776_a("RangedSpread", this.getRangedAttackSpread());
        }
        if (this.getRangedWalkSpeed() >= 0.0f) {
            tag.func_74776_a("RangedWalkSpeed", this.getRangedWalkSpeed());
        }
        if (this.getRangedAttackCooldown() >= 0) {
            tag.func_74777_a("RangedCDMin", (short)this.getRangedAttackCooldown());
        }
        if (this.getRangedAttackMaxCooldown() >= 0) {
            tag.func_74777_a("RangedCDMax", (short)this.getRangedAttackMaxCooldown());
        }
        if (this.getRangedAttackMaxRange() >= 0.0f) {
            tag.func_74776_a("MaxRange", this.getRangedAttackMaxRange());
        }
    }

    public void readFromNBT(CompoundNBT tag) {
        int i;
        if (tag.func_150297_b("RenderScale", 99)) {
            this.setRenderScale(tag.func_74760_g("RenderScale"));
        }
        if (tag.func_150297_b("Experience", 99)) {
            ((ISpecialMob)this.theEntity).setExperience(tag.func_74762_e("Experience"));
        }
        if (tag.func_150297_b("Regeneration", 99)) {
            this.healTimeMax = tag.func_74771_c("Regeneration");
        }
        if (tag.func_150297_b("FallMulti", 99)) {
            this.setFallDamageMultiplier(tag.func_74760_g("FallMulti"));
        }
        if (tag.func_150297_b("FireImmune", 99)) {
            this.setImmuneToFire(tag.func_74767_n("FireImmune"));
        }
        if (tag.func_150297_b("BurningImmune", 99)) {
            this.setImmuneToBurning(tag.func_74767_n("BurningImmune"));
        }
        if (tag.func_150297_b("DrownImmune", 99)) {
            this.setCanBreatheInWater(tag.func_74767_n("DrownImmune"));
        }
        if (tag.func_150297_b("WaterPushImmune", 99)) {
            this.setIgnoreWaterPush(tag.func_74767_n("WaterPushImmune"));
        }
        if (tag.func_150297_b("WaterDamage", 99)) {
            this.setDamagedByWater(tag.func_74767_n("WaterDamage"));
        }
        if (tag.func_150297_b("Leashable", 99)) {
            this.setAllowLeashing(tag.func_74767_n("Leashable"));
        }
        if (tag.func_150297_b("UnderPressure", 99)) {
            this.setIgnorePressurePlates(tag.func_74767_n("UnderPressure"));
        }
        if (tag.func_150297_b("StickyImmune", References.NBT_TYPE_LIST)) {
            ListNBT stickyBlocksTag = tag.func_150295_c("StickyImmune", References.NBT_TYPE_STRING);
            this.immuneToStickyBlocks.clear();
            for (i = 0; i < stickyBlocksTag.size(); ++i) {
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(stickyBlocksTag.func_150307_f(i)));
                if (block == null || block.func_235332_a_(Blocks.field_150350_a)) continue;
                this.immuneToStickyBlocks.add(block);
            }
        }
        if (tag.func_150297_b("PotionImmune", References.NBT_TYPE_LIST)) {
            ListNBT potionsTag = tag.func_150295_c("PotionImmune", References.NBT_TYPE_STRING);
            this.immuneToPotions.clear();
            for (i = 0; i < potionsTag.size(); ++i) {
                Effect effect = (Effect)ForgeRegistries.POTIONS.getValue(new ResourceLocation(potionsTag.func_150307_f(i)));
                if (effect == null) continue;
                this.immuneToPotions.add(effect);
            }
        }
        if (tag.func_150297_b("RangedDamage", 99)) {
            this.setRangedAttackDamage(tag.func_74760_g("RangedDamage"));
        }
        if (tag.func_150297_b("RangedSpread", 99)) {
            this.setRangedAttackSpread(tag.func_74760_g("RangedSpread"));
        }
        if (tag.func_150297_b("RangedWalkSpeed", 99)) {
            this.setRangedWalkSpeed(tag.func_74760_g("RangedWalkSpeed"));
        }
        if (tag.func_150297_b("RangedCDMin", 99)) {
            this.setRangedAttackCooldown(tag.func_74765_d("RangedCDMin"));
        }
        if (tag.func_150297_b("RangedCDMax", 99)) {
            this.setRangedAttackMaxCooldown(tag.func_74765_d("RangedCDMax"));
        }
        if (tag.func_150297_b("MaxRange", 99)) {
            this.setRangedAttackMaxRange(tag.func_74760_g("MaxRange"));
        }
    }
}

