/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity;

import fathertoast.specialmobs.common.config.Config;
import fathertoast.specialmobs.common.entity.ISpecialMob;
import fathertoast.specialmobs.common.entity.creeper._SpecialCreeperEntity;
import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.FrostWalkerEnchantment;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.AxeItem;
import net.minecraft.item.BowItem;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTier;
import net.minecraft.item.Items;
import net.minecraft.item.TieredItem;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectType;
import net.minecraft.potion.Effects;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;

public final class MobHelper {
    private static final EffectInstance[] PLAGUE_EFFECTS = new EffectInstance[]{new EffectInstance(Effects.field_76421_d, 2, 0), new EffectInstance(Effects.field_76419_f, 2, 1), new EffectInstance(Effects.field_76440_q, 1, 0), new EffectInstance(Effects.field_76438_s, 2, 0), new EffectInstance(Effects.field_76437_t, 1, 0), new EffectInstance(Effects.field_76436_u, 1, 0), new EffectInstance(Effects.field_76431_k, 2, 0)};
    private static final EffectInstance[] WITCH_EFFECTS = new EffectInstance[]{new EffectInstance(Effects.field_76421_d, 1, 1), new EffectInstance(Effects.field_76419_f, 2, 1), new EffectInstance(Effects.field_76429_m, 1, -3), new EffectInstance(Effects.field_76440_q, 1, 0), new EffectInstance(Effects.field_76438_s, 2, 0), new EffectInstance(Effects.field_76437_t, 1, 0), new EffectInstance(Effects.field_82731_v, 1, 0), new EffectInstance(Effects.field_188424_y, 1, 1), new EffectInstance(Effects.field_76436_u, 1, 0)};

    @Nullable
    public static ILivingEntityData finalizeSpawn(LivingEntity entity, IServerWorld world, DifficultyInstance difficulty, @Nullable SpawnReason spawnReason, @Nullable ILivingEntityData groupData) {
        ItemStack[] startingEquipment = MobHelper.captureEquipment(entity);
        ((ISpecialMob)entity).finalizeSpecialSpawn(world, difficulty, spawnReason, groupData);
        MobHelper.processSpawnEquipmentChanges(entity, startingEquipment, difficulty);
        return groupData;
    }

    public static ItemStack[] captureEquipment(LivingEntity entity) {
        EquipmentSlotType[] slots = EquipmentSlotType.values();
        ItemStack[] equipment = new ItemStack[slots.length];
        for (int i = 0; i < slots.length; ++i) {
            equipment[i] = entity.func_184582_a(slots[i]);
        }
        return equipment;
    }

    public static void processSpawnEquipmentChanges(LivingEntity entity, ItemStack[] oldEquipment, DifficultyInstance difficulty) {
        float diffMulti = difficulty.func_180170_c();
        EquipmentSlotType[] slots = EquipmentSlotType.values();
        for (int i = 0; i < slots.length; ++i) {
            ItemStack newItem = entity.func_184582_a(slots[i]);
            if (newItem.func_190926_b() || ItemStack.func_77989_b((ItemStack)newItem, (ItemStack)oldEquipment[i])) continue;
            float f = entity.func_70681_au().nextFloat();
            float f2 = slots[i].func_188453_a() == EquipmentSlotType.Group.HAND ? 0.25f : 0.5f;
            if (!(f < f2 * diffMulti)) continue;
            entity.func_184201_a(slots[i], EnchantmentHelper.func_77504_a((Random)entity.func_70681_au(), (ItemStack)newItem, (int)((int)(5.0f + diffMulti * (float)entity.func_70681_au().nextInt(18))), (boolean)false));
        }
    }

    public static void charge(CreeperEntity creeper) {
        if (creeper instanceof _SpecialCreeperEntity) {
            ((_SpecialCreeperEntity)creeper).charge();
        } else {
            creeper.func_184212_Q().func_187227_b(CreeperEntity.field_184714_b, (Object)true);
        }
    }

    public static boolean isDamageSourceIneffectiveAgainstVampires(DamageSource source) {
        if (source.func_151517_h() || source.func_76357_e()) {
            return false;
        }
        Entity attacker = source.func_76346_g();
        if (attacker instanceof LivingEntity) {
            ItemStack weapon = ((LivingEntity)attacker).func_184614_ca();
            return !MobHelper.isWoodenTool(weapon) && !MobHelper.hasSmite(weapon);
        }
        return true;
    }

    private static boolean isWoodenTool(ItemStack item) {
        if (item.func_190926_b()) {
            return false;
        }
        return item.func_77973_b() instanceof TieredItem && ((TieredItem)item.func_77973_b()).func_200891_e() == ItemTier.WOOD || item.func_77973_b() instanceof BowItem || item.func_77973_b() instanceof CrossbowItem;
    }

    private static boolean hasSmite(ItemStack item) {
        return EnchantmentHelper.func_152377_a((ItemStack)item, (CreatureAttribute)CreatureAttribute.field_223223_b_) > 0.0f;
    }

    public static void pull(@Nullable Entity angler, @Nullable Entity fish, double power) {
        if (angler instanceof LivingEntity && fish instanceof LivingEntity) {
            fish.func_213317_d(fish.func_213322_ci().func_186678_a(0.2).func_72441_c((angler.func_226277_ct_() - fish.func_226277_ct_()) * power, Math.min((angler.func_226278_cu_() - fish.func_226278_cu_()) * power + Math.sqrt(fish.func_70032_d(angler)) * 0.1, 2.0), (angler.func_226281_cx_() - fish.func_226281_cx_()) * power));
            fish.field_70133_I = true;
            ((LivingEntity)angler).func_184609_a(Hand.MAIN_HAND);
        }
    }

    public static void knockback(Entity source, LivingEntity target, float power, float upwardMulti) {
        MobHelper.knockback(source, 0.6, target, power, upwardMulti, 0.5);
    }

    public static void knockback(Entity source, double sourceMomentum, LivingEntity target, float power, float upwardMulti, double momentum) {
        float angle = source.field_70177_z * (float)Math.PI / 180.0f;
        MobHelper.knockback(target, power, upwardMulti, (double)MathHelper.func_76126_a((float)angle), (double)(-MathHelper.func_76134_b((float)angle)), momentum);
        source.func_213317_d(source.func_213322_ci().func_216372_d(sourceMomentum, 1.0, sourceMomentum));
    }

    public static void knockback(LivingEntity target, float power, float upwardMulti) {
        MobHelper.knockback(target, power, upwardMulti, 0.5);
    }

    public static void knockback(LivingEntity target, float power, float upwardMulti, double momentum) {
        float angle = target.field_70177_z * (float)Math.PI / 180.0f;
        MobHelper.knockback(target, power, upwardMulti, (double)(-MathHelper.func_76126_a((float)angle)), (double)MathHelper.func_76134_b((float)angle), momentum);
    }

    public static void knockback(LivingEntity target, float power, float upwardMulti, double forwardX, double forwardZ) {
        MobHelper.knockback(target, power, upwardMulti, forwardX, forwardZ, 0.5);
    }

    public static void knockback(LivingEntity target, float power, float upwardMulti, double forwardX, double forwardZ, double momentum) {
        LivingKnockBackEvent event;
        LivingKnockBackEvent livingKnockBackEvent = event = power < 0.0f ? ForgeHooks.onLivingKnockBack((LivingEntity)target, (float)(-power * 0.5f), (double)(-forwardX), (double)(-forwardZ)) : ForgeHooks.onLivingKnockBack((LivingEntity)target, (float)(power * 0.5f), (double)forwardX, (double)forwardZ);
        if (event.isCanceled()) {
            return;
        }
        power = (float)((double)event.getStrength() * (1.0 - target.func_233637_b_(Attributes.field_233820_c_)));
        if (power > 0.0f) {
            target.field_70160_al = true;
            Vector3d v = target.func_213322_ci().func_186678_a(momentum);
            Vector3d vKB = new Vector3d(-event.getRatioX(), 0.0, -event.getRatioZ()).func_72432_b().func_186678_a((double)power);
            double vY = v.field_72448_b + (double)(power * upwardMulti);
            target.func_213293_j(v.field_72450_a + vKB.field_72450_a, target.func_233570_aj_() ? Math.max(0.2, vY) : vY, v.field_72449_c + vKB.field_72449_c);
            target.field_70133_I = true;
        }
    }

    public static void causeLifeLoss(LivingEntity target, float amount) {
        float currentHealth = target.func_110143_aJ();
        if (currentHealth > 1.0f) {
            target.func_70606_j(Math.max(1.0f, currentHealth - amount));
        }
    }

    public static void stealLife(LivingEntity attacker, LivingEntity target, float amount) {
        float currentHealth = target.func_110143_aJ();
        if (currentHealth > 1.0f) {
            float newHealth = Math.max(1.0f, currentHealth - amount);
            target.func_70606_j(newHealth);
            attacker.func_70691_i(currentHealth - newHealth);
        }
    }

    public static ItemStack stealRandomFood(PlayerEntity player) {
        ArrayList<Integer> foodSlots = new ArrayList<Integer>();
        for (int slot = 0; slot < player.field_71071_by.func_70302_i_(); ++slot) {
            ItemStack item = player.field_71071_by.func_70301_a(slot);
            if (item.func_190926_b() || item.func_77973_b().func_219967_s() == null) continue;
            foodSlots.add(slot);
        }
        if (!foodSlots.isEmpty()) {
            return player.field_71071_by.func_70298_a(((Integer)foodSlots.get(player.func_70681_au().nextInt(foodSlots.size()))).intValue(), 1);
        }
        return ItemStack.field_190927_a;
    }

    public static void stealBuffEffect(LivingEntity attacker, LivingEntity target) {
        if (!attacker.field_70170_p.func_201670_d()) {
            for (EffectInstance potion : target.func_70651_bq()) {
                if (potion == null || potion.func_188419_a().func_220303_e() == EffectType.HARMFUL || potion.func_76458_c() < 0) continue;
                target.func_195063_d(potion.func_188419_a());
                attacker.func_195064_c(new EffectInstance(potion.func_188419_a(), Math.max(potion.func_76459_b(), 200), potion.func_76458_c()));
                return;
            }
        }
    }

    public static void removeNightVision(LivingEntity target) {
        target.func_195063_d(Effects.field_76439_r);
    }

    public static void applyPlagueEffect(LivingEntity target, Random random) {
        MobHelper.applyEffectFromTemplate(target, PLAGUE_EFFECTS[random.nextInt(PLAGUE_EFFECTS.length - (Config.MAIN.GENERAL.enableNausea.get() ? 0 : 1))]);
    }

    public static void applyWitchSpiderEffect(LivingEntity target, Random random, boolean includePoison) {
        MobHelper.applyEffectFromTemplate(target, WITCH_EFFECTS[random.nextInt(WITCH_EFFECTS.length - (includePoison ? 0 : 1))]);
    }

    public static void applyEffect(LivingEntity target, Effect effect) {
        MobHelper.applyEffect(target, effect, 1, 1.0f);
    }

    public static void applyEffect(LivingEntity target, Effect effect, int level) {
        MobHelper.applyEffect(target, effect, level, 1.0f);
    }

    public static void applyEffect(LivingEntity target, Effect effect, float durationMulti) {
        MobHelper.applyEffect(target, effect, 1, durationMulti);
    }

    public static void applyEffect(LivingEntity target, Effect effect, int level, float durationMulti) {
        MobHelper.applyEffect(target, effect, level, effect.func_76403_b() ? 1 : (int)((float)MobHelper.defaultEffectDuration(target.field_70170_p.func_175659_aa()) * durationMulti));
    }

    public static void applyDurationEffect(LivingEntity target, Effect effect, int duration) {
        MobHelper.applyEffect(target, effect, 1, duration);
    }

    public static void applyEffect(LivingEntity target, Effect effect, int level, int duration) {
        target.func_195064_c(new EffectInstance(effect, duration, level - 1));
    }

    public static void applyEffectFromTemplate(LivingEntity target, EffectInstance template) {
        MobHelper.applyEffectFromTemplate(target, template, MobHelper.defaultEffectDuration(target.field_70170_p.func_175659_aa()));
    }

    public static void applyEffectFromTemplate(LivingEntity target, EffectInstance template, int baseDuration) {
        target.func_195064_c(new EffectInstance(template.func_188419_a(), template.func_188419_a().func_76403_b() ? 1 : baseDuration * template.func_76459_b(), template.func_76458_c()));
    }

    public static AbstractArrowEntity tipPlagueArrow(AbstractArrowEntity arrow, Random random) {
        return MobHelper.tipArrowFromTemplate(arrow, PLAGUE_EFFECTS[random.nextInt(PLAGUE_EFFECTS.length - (Config.MAIN.GENERAL.enableNausea.get() ? 0 : 1))]);
    }

    public static AbstractArrowEntity tipArrow(AbstractArrowEntity arrow, Effect effect) {
        return MobHelper.tipArrow(arrow, effect, 1, 1.0f);
    }

    public static AbstractArrowEntity tipArrow(AbstractArrowEntity arrow, Effect effect, int level) {
        return MobHelper.tipArrow(arrow, effect, level, 1.0f);
    }

    public static AbstractArrowEntity tipArrow(AbstractArrowEntity arrow, Effect effect, float durationMulti) {
        return MobHelper.tipArrow(arrow, effect, 1, durationMulti);
    }

    public static AbstractArrowEntity tipArrow(AbstractArrowEntity arrow, Effect effect, int level, float durationMulti) {
        return MobHelper.tipArrow(arrow, effect, level, effect.func_76403_b() ? 1 : (int)((float)MobHelper.defaultEffectDuration(arrow.field_70170_p.func_175659_aa()) * durationMulti));
    }

    public static AbstractArrowEntity tipArrow(AbstractArrowEntity arrow, Effect effect, int level, int duration) {
        if (arrow instanceof ArrowEntity) {
            ((ArrowEntity)arrow).func_184558_a(new EffectInstance(effect, duration, level - 1));
        }
        return arrow;
    }

    public static AbstractArrowEntity tipArrowFromTemplate(AbstractArrowEntity arrow, EffectInstance template) {
        return MobHelper.tipArrowFromTemplate(arrow, template, MobHelper.defaultEffectDuration(arrow.field_70170_p.func_175659_aa()));
    }

    public static AbstractArrowEntity tipArrowFromTemplate(AbstractArrowEntity arrow, EffectInstance template, int baseDuration) {
        if (arrow instanceof ArrowEntity) {
            ((ArrowEntity)arrow).func_184558_a(new EffectInstance(template.func_188419_a(), template.func_188419_a().func_76403_b() ? 1 : baseDuration * template.func_76459_b(), template.func_76458_c()));
        }
        return arrow;
    }

    public static int defaultEffectDuration(Difficulty difficulty) {
        switch (difficulty) {
            case PEACEFUL: 
            case EASY: {
                return 60;
            }
            case NORMAL: {
                return 140;
            }
        }
        return 300;
    }

    public static boolean tryBlockAttack(LivingEntity blocker, DamageSource source, boolean needsShield) {
        AbstractArrowEntity arrow;
        Entity attacker;
        if (blocker.field_70170_p.func_201670_d() || blocker.func_180431_b(source) || source.func_76363_c()) {
            return false;
        }
        if (blocker.func_70681_au().nextFloat() >= 0.33f && ((attacker = source.func_76346_g()) == null || blocker.func_70068_e(attacker) < 36.0)) {
            return false;
        }
        Entity entity = source.func_76364_f();
        if (entity instanceof AbstractArrowEntity && (arrow = (AbstractArrowEntity)entity).func_213874_s() > 0) {
            return false;
        }
        Hand shieldHand = Hand.OFF_HAND;
        ItemStack shield = blocker.func_184586_b(shieldHand);
        if (!(!needsShield || !shield.func_190926_b() && shield.isShield(blocker) || !(shield = blocker.func_184586_b(shieldHand = Hand.MAIN_HAND)).func_190926_b() && shield.isShield(blocker))) {
            return false;
        }
        Vector3d sourcePos = source.func_188404_v();
        if (sourcePos != null) {
            Vector3d lookVec = blocker.func_70676_i(1.0f);
            Vector3d targetVec = sourcePos.func_72444_a(blocker.func_213303_ch()).func_72432_b();
            targetVec = new Vector3d(targetVec.field_72450_a, 0.0, targetVec.field_72449_c);
            if (targetVec.func_72430_b(lookVec) < 0.0) {
                blocker.field_70170_p.func_184148_a(null, blocker.func_226277_ct_() + 0.5, blocker.func_226278_cu_(), blocker.func_226281_cx_() + 0.5, SoundEvents.field_187767_eL, SoundCategory.NEUTRAL, 0.9f, 1.0f);
                if (needsShield && entity instanceof PlayerEntity) {
                    MobHelper.maybeDestroyShield(blocker, shield, shieldHand, ((PlayerEntity)entity).func_184614_ca());
                }
                if (!source.func_76352_a() && entity instanceof LivingEntity) {
                    ((LivingEntity)entity).func_233627_a_(0.5f, blocker.func_226277_ct_() - entity.func_226277_ct_(), blocker.func_226281_cx_() - entity.func_226281_cx_());
                    entity.field_70133_I = true;
                }
                return true;
            }
        }
        return false;
    }

    private static void maybeDestroyShield(LivingEntity blocker, ItemStack shield, Hand shieldHand, ItemStack weapon) {
        if (!weapon.func_190926_b() && !shield.func_190926_b() && weapon.func_77973_b() instanceof AxeItem && shield.func_77973_b() == Items.field_185159_cQ && blocker.func_70681_au().nextFloat() < 0.25f - (float)EnchantmentHelper.func_185293_e((LivingEntity)blocker) * 0.05f) {
            blocker.field_70170_p.func_184148_a(null, blocker.func_226277_ct_() + 0.5, blocker.func_226278_cu_(), blocker.func_226281_cx_() + 0.5, SoundEvents.field_187769_eM, SoundCategory.NEUTRAL, 0.9f, 1.0f);
            blocker.func_213334_d(shieldHand);
            blocker.func_184611_a(shieldHand, ItemStack.field_190927_a);
        }
    }

    public static void floatInFluid(Entity entity, double acceleration, ITag<Fluid> fluid) {
        if (entity.field_70173_aa > 1 && entity.func_233571_b_(fluid) > 0.0) {
            if (ISelectionContext.func_216374_a((Entity)entity).func_216378_a(FlowingFluidBlock.field_235510_c_, entity.func_233580_cy_(), true) && !entity.field_70170_p.func_204610_c(entity.func_233580_cy_().func_177984_a()).func_206884_a(fluid)) {
                entity.func_230245_c_(true);
            } else {
                entity.func_213317_d(entity.func_213322_ci().func_186678_a(0.5).func_72441_c(0.0, acceleration, 0.0));
            }
        }
    }

    public static void updateFrostWalker(LivingEntity entity, BlockPos pos) {
        MobHelper.updateFrostWalker(entity, pos, 1);
    }

    public static void updateFrostWalker(LivingEntity entity, BlockPos pos, int level) {
        boolean actualOnGround = entity.func_233570_aj_();
        entity.func_230245_c_(true);
        FrostWalkerEnchantment.func_185266_a((LivingEntity)entity, (World)entity.field_70170_p, (BlockPos)pos, (int)level);
        entity.func_230245_c_(actualOnGround);
    }

    public static void hopOnFluid(Entity entity) {
        if (entity.field_70173_aa > 1 && entity.func_233570_aj_() && entity.field_70170_p.field_73012_v.nextInt(10) == 0 && ISelectionContext.func_216374_a((Entity)entity).func_216378_a(FlowingFluidBlock.field_235510_c_, entity.func_233580_cy_(), true) && !entity.field_70170_p.func_204610_c(entity.func_233580_cy_().func_177984_a()).func_206884_a((ITag)FluidTags.field_206959_a)) {
            BlockState block = entity.field_70170_p.func_180495_p(entity.func_233580_cy_());
            if (block.func_185904_a() == Material.field_203243_f || block.func_185904_a() == Material.field_204868_h) {
                TileEntity tileEntity = block.hasTileEntity() ? entity.field_70170_p.func_175625_s(entity.func_233580_cy_()) : null;
                Block.func_220059_a((BlockState)block, (IWorld)entity.field_70170_p, (BlockPos)entity.func_233580_cy_(), (TileEntity)tileEntity);
                entity.field_70170_p.func_180501_a(entity.func_233580_cy_(), Blocks.field_150355_j.func_176223_P(), 3);
            }
            entity.func_213317_d(entity.func_213322_ci().func_186678_a(0.5).func_72441_c(0.0, 0.4, 0.0));
        }
    }

    public static boolean placeBlock(Entity entity, BlockPos pos, BlockState block) {
        return MobHelper.placeBlock(entity, pos, block, 3);
    }

    public static boolean placeBlock(Entity entity, BlockPos pos, Direction direction, BlockState block) {
        return MobHelper.placeBlock(entity, pos, direction, block, 3);
    }

    public static boolean placeBlock(Entity entity, BlockPos pos, BlockState block, int updateFlags) {
        return MobHelper.placeBlock(entity, pos, Direction.UP, block, updateFlags);
    }

    public static boolean placeBlock(Entity entity, BlockPos pos, Direction direction, BlockState block, int updateFlags) {
        if (MobHelper.canPlaceBlock(entity, pos, direction)) {
            entity.field_70170_p.func_180501_a(pos, block, updateFlags);
            return true;
        }
        return false;
    }

    public static boolean canPlaceBlock(Entity entity, BlockPos pos) {
        return MobHelper.canPlaceBlock(entity, pos, Direction.UP);
    }

    public static boolean canPlaceBlock(Entity entity, BlockPos pos, Direction direction) {
        return !ForgeEventFactory.onBlockPlace((Entity)entity, (BlockSnapshot)BlockSnapshot.create((RegistryKey)entity.field_70170_p.func_234923_W_(), (IWorld)entity.field_70170_p, (BlockPos)pos), (Direction)direction);
    }
}

