/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.core;

import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.config.Config;
import fathertoast.specialmobs.common.config.family.FamilyConfig;
import fathertoast.specialmobs.common.core.SpecialMobs;
import fathertoast.specialmobs.common.entity.MobHelper;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="specialmobs", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class SpecialMobReplacer {
    private static final Deque<MobReplacementEntry> TO_REPLACE = new ArrayDeque<MobReplacementEntry>();
    private static final Predicate<MobFamily.Species<?>> WATER_INSENSITIVE_SELECTOR = species -> !species.config.GENERAL.isDamagedByWater.get();
    private static final Predicate<MobFamily.Species<?>> NO_GIANTS_SELECTOR = MobFamily.Species::isNotGiant;

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onEntitySpawn(EntityJoinWorldEvent event) {
        if (event.getWorld().func_201670_d() || !Config.MAIN.GENERAL.enableMobReplacement.get() || event.isCanceled()) {
            return;
        }
        Entity entity = event.getEntity();
        MobFamily<?, ?> mobFamily = SpecialMobReplacer.getReplacingMobFamily(entity);
        if (mobFamily != null) {
            World world = event.getWorld();
            BlockPos entityPos = new BlockPos(entity.func_213303_ch());
            SpecialMobReplacer.setInitFlag(entity);
            boolean isSpecial = SpecialMobReplacer.shouldMakeNextSpecial(mobFamily, world, entityPos);
            if (SpecialMobReplacer.shouldReplace(mobFamily, isSpecial)) {
                TO_REPLACE.addLast(new MobReplacementEntry(mobFamily, isSpecial, entity, world, entityPos));
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            while (!TO_REPLACE.isEmpty()) {
                MobReplacementEntry replacement = TO_REPLACE.removeFirst();
                SpecialMobReplacer.replace(replacement.mobFamily, replacement.isSpecial, (Entity)replacement.entityToReplace, replacement.entityWorld, replacement.entityPos);
            }
        }
    }

    private static boolean getInitFlag(Entity entity) {
        CompoundNBT forgeData = entity.getPersistentData();
        if (forgeData.func_150297_b("SpecialMobsInit", 99)) {
            return forgeData.func_74767_n("SpecialMobsInit");
        }
        return false;
    }

    private static void setInitFlag(Entity entity) {
        CompoundNBT forgeData = entity.getPersistentData();
        forgeData.func_74757_a("SpecialMobsInit", true);
    }

    @Nullable
    private static MobFamily<?, ?> getReplacingMobFamily(@Nullable Entity entity) {
        if (entity == null || SpecialMobReplacer.getInitFlag(entity)) {
            return null;
        }
        return MobFamily.getReplacementFamily(entity);
    }

    private static boolean shouldMakeNextSpecial(MobFamily<?, ?> mobFamily, World world, BlockPos entityPos) {
        return world.field_73012_v.nextDouble() < ((FamilyConfig)mobFamily.config).GENERAL.specialVariantChance.get(world, entityPos);
    }

    private static boolean shouldReplace(MobFamily<?, ?> mobFamily, boolean isSpecial) {
        return isSpecial || ((FamilyConfig)mobFamily.config).GENERAL.vanillaReplacement.get();
    }

    private static void replace(MobFamily<?, ?> mobFamily, boolean isSpecial, Entity entityToReplace, World world, BlockPos entityPos) {
        if (!(world instanceof IServerWorld)) {
            return;
        }
        CompoundNBT tag = new CompoundNBT();
        entityToReplace.func_189511_e(tag);
        tag.func_82580_o("UUID");
        MobFamily.Species species = isSpecial ? mobFamily.nextVariant(world, entityPos, SpecialMobReplacer.getVariantFilter(mobFamily, entityToReplace, world, entityPos)) : mobFamily.vanillaReplacement;
        LivingEntity replacement = (LivingEntity)((EntityType)species.entityType.get()).func_200721_a(world);
        if (replacement == null) {
            SpecialMobs.LOG.error("Failed to create replacement entity '{}'", (Object)species.entityType.getId());
            return;
        }
        replacement.func_70020_e(tag);
        MobHelper.finalizeSpawn(replacement, (IServerWorld)world, world.func_175649_E(entityPos), null, null);
        world.func_217376_c((Entity)replacement);
        for (Entity rider : entityToReplace.func_184188_bt()) {
            rider.func_184210_p();
            rider.func_184205_a((Entity)replacement, true);
        }
        if (entityToReplace.func_184187_bx() != null) {
            Entity vehicle = entityToReplace.func_184187_bx();
            entityToReplace.func_184210_p();
            replacement.func_184205_a(vehicle, true);
        }
        entityToReplace.func_70106_y();
    }

    @Nullable
    private static Predicate<MobFamily.Species<?>> getVariantFilter(MobFamily<?, ?> mobFamily, Entity entityToReplace, World world, BlockPos entityPos) {
        Predicate<MobFamily.Species<?>> selector = null;
        if (!mobFamily.vanillaReplacement.bestiaryInfo.isDamagedByWater && world.func_175727_C(entityPos)) {
            selector = WATER_INSENSITIVE_SELECTOR;
        }
        if (mobFamily.hasAnyGiants()) {
            AxisAlignedBB bb = entityToReplace.func_174813_aQ();
            int y = MathHelper.func_76143_f((double)bb.field_72337_e);
            if (!world.func_195585_a(entityToReplace, VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(bb.field_72340_a, (double)y, bb.field_72339_c, bb.field_72336_d, (double)(y + 1), bb.field_72334_f)))) {
                selector = selector == null ? NO_GIANTS_SELECTOR : selector.and(NO_GIANTS_SELECTOR);
            }
        }
        return selector;
    }

    private static class MobReplacementEntry {
        final MobFamily<?, ?> mobFamily;
        final boolean isSpecial;
        final LivingEntity entityToReplace;
        final World entityWorld;
        final BlockPos entityPos;

        MobReplacementEntry(MobFamily<?, ?> family, boolean special, Entity entity, World world, BlockPos pos) {
            this.mobFamily = family;
            this.isSpecial = special;
            this.entityToReplace = (LivingEntity)entity;
            this.entityWorld = world;
            this.entityPos = pos;
        }
    }
}

