/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.config.util.environment.time;

import fathertoast.specialmobs.common.config.field.AbstractConfigField;
import fathertoast.specialmobs.common.config.util.environment.EnumEnvironment;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class DayTimeEnvironment
extends EnumEnvironment<Value> {
    public DayTimeEnvironment(Value value, boolean invert) {
        super(value, invert);
    }

    public DayTimeEnvironment(AbstractConfigField field, String line) {
        super(field, line, (Enum[])Value.values());
    }

    @Override
    public String name() {
        return "day_time";
    }

    @Override
    public boolean matches(World world, @Nullable BlockPos pos) {
        return ((Value)this.VALUE).matches((int)(world.func_241851_ab() / 24000L)) != this.INVERT;
    }

    public static enum Value {
        DAY(1000, 13000),
        SUNSET(12000, 13000),
        NIGHT(13000, 1000),
        SUNRISE(23000, 1000);

        private final int START;
        private final int END;

        private Value(int start, int end) {
            this.START = start;
            this.END = end;
        }

        public boolean matches(int dayTime) {
            if (this.START < this.END) {
                return this.START <= dayTime && dayTime < this.END;
            }
            return this.START <= dayTime || dayTime < this.END;
        }
    }
}

