/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.config.util.environment.position;

import fathertoast.specialmobs.common.config.field.AbstractConfigField;
import fathertoast.specialmobs.common.config.util.environment.EnumEnvironment;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class PositionEnvironment
extends EnumEnvironment<Value> {
    public PositionEnvironment(Value value, boolean invert) {
        super(value, invert);
    }

    public PositionEnvironment(AbstractConfigField field, String line) {
        super(field, line, (Enum[])Value.values());
    }

    @Override
    public String name() {
        return "position";
    }

    @Override
    public boolean matches(World world, @Nullable BlockPos pos) {
        return ((Value)this.VALUE).of(world, pos) != this.INVERT;
    }

    public static enum Value {
        CAN_SEE_SKY((world, pos) -> pos != null && world.func_226660_f_(pos)),
        IS_IN_VILLAGE((world, pos) -> pos != null && world instanceof ServerWorld && ((ServerWorld)world).func_217483_b_(pos)),
        IS_NEAR_VILLAGE((world, pos) -> pos != null && world instanceof ServerWorld && ((ServerWorld)world).func_241119_a_(pos, 3)),
        IS_NEAR_RAID((world, pos) -> pos != null && world instanceof ServerWorld && ((ServerWorld)world).func_217455_d_(pos)),
        IS_IN_WATER((world, pos) -> pos != null && world.func_204610_c(pos).func_206884_a((ITag)FluidTags.field_206959_a)),
        IS_IN_LAVA((world, pos) -> pos != null && world.func_204610_c(pos).func_206884_a((ITag)FluidTags.field_206960_b)),
        IS_IN_FLUID((world, pos) -> pos != null && !world.func_204610_c(pos).func_206888_e()),
        HAS_REDSTONE_POWER((world, pos) -> pos != null && world.func_175676_y(pos) > 0);

        private final BiFunction<World, BlockPos, Boolean> SUPPLIER;

        private Value(BiFunction<World, BlockPos, Boolean> supplier) {
            this.SUPPLIER = supplier;
        }

        public boolean of(World world, @Nullable BlockPos pos) {
            return this.SUPPLIER.apply(world, pos);
        }
    }
}

