/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.config.util.environment.dimension;

import fathertoast.specialmobs.common.config.field.AbstractConfigField;
import fathertoast.specialmobs.common.config.util.environment.EnumEnvironment;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;

public class DimensionPropertyEnvironment
extends EnumEnvironment<Value> {
    public DimensionPropertyEnvironment(Value value, boolean invert) {
        super(value, invert);
    }

    public DimensionPropertyEnvironment(AbstractConfigField field, String line) {
        super(field, line, (Enum[])Value.values());
    }

    @Override
    public String name() {
        return "dimension_property";
    }

    @Override
    public boolean matches(World world, @Nullable BlockPos pos) {
        return ((Value)this.VALUE).of(world.func_230315_m_()) != this.INVERT;
    }

    public static enum Value {
        ULTRAWARM(DimensionType::func_236040_e_),
        NATURAL(DimensionType::func_236043_f_),
        HAS_SKYLIGHT(DimensionType::func_218272_d),
        HAS_CEILING(DimensionType::func_236037_d_),
        FIXED_TIME(DimensionType::func_241514_p_),
        PIGLIN_SAFE(DimensionType::func_241509_i_),
        BED_WORKS(DimensionType::func_241510_j_),
        RESPAWN_ANCHOR_WORKS(DimensionType::func_241511_k_),
        HAS_RAIDS(DimensionType::func_241512_l_);

        private final Function<DimensionType, Boolean> SUPPLIER;

        private Value(Function<DimensionType, Boolean> supplier) {
            this.SUPPLIER = supplier;
        }

        public boolean of(DimensionType dimType) {
            return this.SUPPLIER.apply(dimType);
        }
    }
}

