/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.config.util.environment.biome;

import fathertoast.specialmobs.common.config.field.AbstractConfigField;
import fathertoast.specialmobs.common.config.util.environment.CompareFloatEnvironment;
import fathertoast.specialmobs.common.config.util.environment.ComparisonOperator;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TemperatureEnvironment
extends CompareFloatEnvironment {
    public static final String FREEZING = "freezing";
    public static final float FREEZING_POINT = 0.15f;

    public static String handleTempInput(String line) {
        if (line.equalsIgnoreCase(FREEZING)) {
            return (Object)((Object)ComparisonOperator.LESS_THAN) + " " + 0.15f;
        }
        if (line.equalsIgnoreCase("!freezing")) {
            return (Object)((Object)ComparisonOperator.LESS_THAN.invert()) + " " + 0.15f;
        }
        return line;
    }

    public TemperatureEnvironment(boolean freezing) {
        this(ComparisonOperator.LESS_THAN.invert(!freezing), 0.15f);
    }

    public TemperatureEnvironment(ComparisonOperator op, float value) {
        super(op, value);
    }

    public TemperatureEnvironment(AbstractConfigField field, String line) {
        super(field, TemperatureEnvironment.handleTempInput(line));
    }

    @Override
    public String name() {
        return "temp";
    }

    @Override
    public String value() {
        if (this.COMPARATOR == ComparisonOperator.LESS_THAN && this.VALUE == 0.15f) {
            return FREEZING;
        }
        if (this.COMPARATOR == ComparisonOperator.LESS_THAN.invert() && this.VALUE == 0.15f) {
            return "!freezing";
        }
        return super.value();
    }

    @Override
    public float getActual(World world, @Nullable BlockPos pos) {
        return pos == null ? Float.NaN : world.func_226691_t_(pos).func_225486_c(pos);
    }
}

