/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.config.util.environment;

import fathertoast.specialmobs.common.config.field.AbstractConfigField;
import fathertoast.specialmobs.common.config.util.environment.AbstractEnvironment;
import fathertoast.specialmobs.common.core.SpecialMobs;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public abstract class RegistryEnvironment<T extends IForgeRegistryEntry<T>>
extends AbstractEnvironment {
    private final AbstractConfigField FIELD;
    protected final boolean INVERT;
    private final ResourceLocation REGISTRY_KEY;
    private T registryEntry;

    public RegistryEnvironment(T regEntry, boolean invert) {
        this.FIELD = null;
        this.INVERT = invert;
        this.REGISTRY_KEY = regEntry.getRegistryName();
        this.registryEntry = regEntry;
    }

    public RegistryEnvironment(AbstractConfigField field, String line) {
        this.FIELD = field;
        this.INVERT = line.startsWith("!");
        this.REGISTRY_KEY = new ResourceLocation(this.INVERT ? line.substring(1) : line);
    }

    @Override
    public final String value() {
        return (this.INVERT ? "!" : "") + this.REGISTRY_KEY.toString();
    }

    public abstract IForgeRegistry<T> getRegistry();

    @Nullable
    protected final T getRegistryEntry() {
        if (this.registryEntry == null) {
            if (!this.getRegistry().containsKey(this.REGISTRY_KEY)) {
                SpecialMobs.LOG.warn("Invalid entry for {} \"{}\"! Not present in registry \"{}\". Invalid entry: {}", this.FIELD.getClass(), (Object)this.FIELD.getKey(), (Object)this.getRegistry().getRegistryName(), (Object)this.REGISTRY_KEY);
            }
            this.registryEntry = this.getRegistry().getValue(this.REGISTRY_KEY);
        }
        return this.registryEntry;
    }
}

