/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.config.util.environment;

import fathertoast.specialmobs.common.config.field.AbstractConfigField;
import fathertoast.specialmobs.common.config.file.TomlHelper;
import fathertoast.specialmobs.common.config.util.environment.AbstractEnvironment;
import fathertoast.specialmobs.common.core.SpecialMobs;
import java.util.Locale;

public abstract class EnumEnvironment<T extends Enum<T>>
extends AbstractEnvironment {
    protected final boolean INVERT;
    protected final T VALUE;

    public EnumEnvironment(T value, boolean invert) {
        this.INVERT = invert;
        this.VALUE = value;
    }

    public EnumEnvironment(AbstractConfigField field, String line, T[] validValues) {
        this.INVERT = line.startsWith("!");
        this.VALUE = this.parseValue(field, line, (Enum[])validValues, this.INVERT ? line.substring(1) : line);
    }

    private T parseValue(AbstractConfigField field, String line, T[] validValues, String name) {
        for (T value : validValues) {
            if (!((Enum)value).name().equalsIgnoreCase(name)) continue;
            return value;
        }
        SpecialMobs.LOG.warn("Invalid entry for {} \"{}\"! Value not defined (must be in the set [ {} ]). Defaulting to {}. Invalid entry: {}", field.getClass(), (Object)field.getKey(), (Object)TomlHelper.literalList(validValues), (Object)TomlHelper.toLiteral(new Object[0]), (Object)line);
        return validValues[0];
    }

    @Override
    public final String value() {
        return (this.INVERT ? "!" : "") + ((Enum)this.VALUE).name().toLowerCase(Locale.ROOT);
    }
}

