/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.config.util.environment;

import fathertoast.specialmobs.common.config.field.AbstractConfigField;
import fathertoast.specialmobs.common.config.util.ConfigUtil;
import fathertoast.specialmobs.common.config.util.environment.AbstractEnvironment;
import fathertoast.specialmobs.common.core.SpecialMobs;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public abstract class DynamicRegistryGroupEnvironment<T>
extends AbstractEnvironment {
    private final AbstractConfigField FIELD;
    protected final boolean INVERT;
    private final String NAMESPACE;
    private List<T> registryEntries;
    private byte version = (byte)-1;

    public DynamicRegistryGroupEnvironment(ResourceLocation regKey, boolean invert) {
        this.FIELD = null;
        this.INVERT = invert;
        this.NAMESPACE = regKey.toString();
    }

    public DynamicRegistryGroupEnvironment(AbstractConfigField field, String line) {
        this.FIELD = field;
        this.INVERT = line.startsWith("!");
        this.NAMESPACE = line.substring(this.INVERT ? 1 : 0, line.length() - 1);
    }

    @Override
    public final String value() {
        return (this.INVERT ? "!" : "") + this.NAMESPACE + "*";
    }

    public abstract RegistryKey<Registry<T>> getRegistry();

    @Override
    public final boolean matches(World world, @Nullable BlockPos pos) {
        if (world instanceof ServerWorld) {
            return this.matches((ServerWorld)world, pos);
        }
        return this.INVERT;
    }

    public abstract boolean matches(ServerWorld var1, @Nullable BlockPos var2);

    protected final List<T> getRegistryEntries(ServerWorld world) {
        if (this.version != ConfigUtil.DYNAMIC_REGISTRY_VERSION) {
            this.version = ConfigUtil.DYNAMIC_REGISTRY_VERSION;
            this.registryEntries = new ArrayList<T>();
            MutableRegistry registry = world.func_73046_m().func_244267_aX().func_243612_b(this.getRegistry());
            for (ResourceLocation regKey : registry.func_148742_b()) {
                Object entry;
                if (!regKey.toString().startsWith(this.NAMESPACE) || (entry = registry.func_82594_a(regKey)) == null) continue;
                this.registryEntries.add(entry);
            }
            if (this.registryEntries.isEmpty()) {
                SpecialMobs.LOG.info("Namespace entry for {} \"{}\" did not match anything in registry \"{}\"! Questionable entry: {}", this.FIELD == null ? "DEFAULT" : this.FIELD.getClass(), (Object)(this.FIELD == null ? "DEFAULT" : this.FIELD.getKey()), (Object)this.getRegistry().func_240901_a_(), (Object)this.NAMESPACE);
            }
            this.registryEntries = Collections.unmodifiableList(this.registryEntries);
        }
        return this.registryEntries;
    }
}

