/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.config.util.environment;

import fathertoast.specialmobs.common.config.field.AbstractConfigField;
import fathertoast.specialmobs.common.config.util.ConfigUtil;
import fathertoast.specialmobs.common.config.util.environment.AbstractEnvironment;
import fathertoast.specialmobs.common.core.SpecialMobs;
import javax.annotation.Nullable;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public abstract class DynamicRegistryEnvironment<T>
extends AbstractEnvironment {
    private final AbstractConfigField FIELD;
    protected final boolean INVERT;
    private final ResourceLocation REGISTRY_KEY;
    private T registryEntry;
    private byte version = (byte)-1;

    public DynamicRegistryEnvironment(ResourceLocation regKey, boolean invert) {
        this.FIELD = null;
        this.INVERT = invert;
        this.REGISTRY_KEY = regKey;
    }

    public DynamicRegistryEnvironment(AbstractConfigField field, String line) {
        this.FIELD = field;
        this.INVERT = line.startsWith("!");
        this.REGISTRY_KEY = new ResourceLocation(this.INVERT ? line.substring(1) : line);
    }

    @Override
    public final String value() {
        return (this.INVERT ? "!" : "") + this.REGISTRY_KEY.toString();
    }

    public abstract RegistryKey<Registry<T>> getRegistry();

    @Override
    public final boolean matches(World world, @Nullable BlockPos pos) {
        if (world instanceof ServerWorld) {
            return this.matches((ServerWorld)world, pos);
        }
        return this.INVERT;
    }

    public abstract boolean matches(ServerWorld var1, @Nullable BlockPos var2);

    @Nullable
    public final T getRegistryEntry(ServerWorld world) {
        if (this.version != ConfigUtil.DYNAMIC_REGISTRY_VERSION) {
            this.version = ConfigUtil.DYNAMIC_REGISTRY_VERSION;
            MutableRegistry registry = world.func_73046_m().func_244267_aX().func_243612_b(this.getRegistry());
            this.registryEntry = registry.func_82594_a(this.REGISTRY_KEY);
            if (this.registryEntry == null) {
                SpecialMobs.LOG.info("Missing entry for {} \"{}\"! Not present in registry \"{}\". Missing entry: {}", this.FIELD.getClass(), (Object)this.FIELD.getKey(), (Object)this.getRegistry().func_240901_a_(), (Object)this.REGISTRY_KEY);
            }
        }
        return this.registryEntry;
    }
}

