/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.config.util.environment;

import javax.annotation.Nullable;

public enum ComparisonOperator {
    NOT_EQUAL_TO("!="),
    LESS_OR_EQUAL("<="),
    GREATER_OR_EQUAL(">="),
    EQUAL_TO("="),
    LESS_THAN("<"),
    GREATER_THAN(">");

    private final String LITERAL;

    private ComparisonOperator(String str) {
        this.LITERAL = str;
    }

    public String toString() {
        return this.LITERAL;
    }

    public ComparisonOperator invert(boolean invert) {
        return invert ? this.invert() : this;
    }

    public ComparisonOperator invert() {
        switch (this) {
            case LESS_THAN: {
                return GREATER_OR_EQUAL;
            }
            case LESS_OR_EQUAL: {
                return GREATER_THAN;
            }
            case GREATER_THAN: {
                return LESS_OR_EQUAL;
            }
            case GREATER_OR_EQUAL: {
                return LESS_THAN;
            }
            case EQUAL_TO: {
                return NOT_EQUAL_TO;
            }
            case NOT_EQUAL_TO: {
                return EQUAL_TO;
            }
        }
        throw new IllegalStateException("Inversion implementation is invalid! :(");
    }

    public boolean apply(float first, float second) {
        switch (this) {
            case LESS_THAN: {
                return first < second;
            }
            case LESS_OR_EQUAL: {
                return first <= second;
            }
            case GREATER_THAN: {
                return first > second;
            }
            case GREATER_OR_EQUAL: {
                return first >= second;
            }
            case EQUAL_TO: {
                return first == second;
            }
            case NOT_EQUAL_TO: {
                return first != second;
            }
        }
        throw new IllegalStateException("Float comparison implementation is invalid! :(");
    }

    public boolean apply(int first, int second) {
        switch (this) {
            case LESS_THAN: {
                return first < second;
            }
            case LESS_OR_EQUAL: {
                return first <= second;
            }
            case GREATER_THAN: {
                return first > second;
            }
            case GREATER_OR_EQUAL: {
                return first >= second;
            }
            case EQUAL_TO: {
                return first == second;
            }
            case NOT_EQUAL_TO: {
                return first != second;
            }
        }
        throw new IllegalStateException("Integer comparison implementation is invalid! :(");
    }

    public boolean apply(long first, long second) {
        switch (this) {
            case LESS_THAN: {
                return first < second;
            }
            case LESS_OR_EQUAL: {
                return first <= second;
            }
            case GREATER_THAN: {
                return first > second;
            }
            case GREATER_OR_EQUAL: {
                return first >= second;
            }
            case EQUAL_TO: {
                return first == second;
            }
            case NOT_EQUAL_TO: {
                return first != second;
            }
        }
        throw new IllegalStateException("Long comparison implementation is invalid! :(");
    }

    @Nullable
    public static ComparisonOperator parse(String op) {
        for (ComparisonOperator operator : ComparisonOperator.values()) {
            if (!op.startsWith(operator.LITERAL)) continue;
            return operator;
        }
        return null;
    }
}

