/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.config.util.environment;

import fathertoast.specialmobs.common.config.field.AbstractConfigField;
import fathertoast.specialmobs.common.config.file.TomlHelper;
import fathertoast.specialmobs.common.config.util.environment.AbstractEnvironment;
import fathertoast.specialmobs.common.config.util.environment.ComparisonOperator;
import fathertoast.specialmobs.common.core.SpecialMobs;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class CompareIntEnvironment
extends AbstractEnvironment {
    public final ComparisonOperator COMPARATOR;
    public final int VALUE;

    public CompareIntEnvironment(ComparisonOperator op, int value) {
        this.COMPARATOR = op;
        this.VALUE = value;
    }

    public CompareIntEnvironment(AbstractConfigField field, String line) {
        if (line.isEmpty()) {
            this.COMPARATOR = ComparisonOperator.LESS_THAN;
            this.VALUE = 0;
            SpecialMobs.LOG.warn("Invalid entry for {} \"{}\"! Not defined. Defaulting to \"{}\". Invalid entry: {}", field.getClass(), (Object)field.getKey(), (Object)this.value(), (Object)line);
        } else {
            ComparisonOperator op = ComparisonOperator.parse(line);
            if (op == null) {
                this.COMPARATOR = ComparisonOperator.LESS_THAN;
                SpecialMobs.LOG.warn("Invalid entry for {} \"{}\"! Comparison not defined (must be in the set [ {} ]). Defaulting to \"{}\". Invalid entry: {}", field.getClass(), (Object)field.getKey(), (Object)TomlHelper.literalList((Object[])ComparisonOperator.values()), (Object)this.COMPARATOR, (Object)line);
            } else {
                this.COMPARATOR = op;
            }
            this.VALUE = this.parseValue(field, line, line.substring(this.COMPARATOR.toString().length()).trim());
        }
    }

    private int parseValue(AbstractConfigField field, String line, String arg) {
        int value;
        try {
            value = Integer.parseInt(arg);
        }
        catch (NumberFormatException ex) {
            SpecialMobs.LOG.warn("Invalid entry for {} \"{}\"! Value not defined (must be an integer). Defaulting to '0'. Invalid entry: {}", field.getClass(), (Object)field.getKey(), (Object)line);
            value = 0;
        }
        if (value < this.getMinValue()) {
            SpecialMobs.LOG.warn("Value for {} \"{}\" is below the minimum ({})! Clamping value. Invalid value: {}", field.getClass(), (Object)field.getKey(), (Object)this.getMinValue(), (Object)value);
            value = this.getMinValue();
        } else if (value > this.getMaxValue()) {
            SpecialMobs.LOG.warn("Value for {} \"{}\" is above the maximum ({})! Clamping value. Invalid value: {}", field.getClass(), (Object)field.getKey(), (Object)this.getMaxValue(), (Object)value);
            value = this.getMaxValue();
        }
        return value;
    }

    protected int getMinValue() {
        return Integer.MIN_VALUE;
    }

    protected int getMaxValue() {
        return Integer.MAX_VALUE;
    }

    @Override
    public String value() {
        return (Object)((Object)this.COMPARATOR) + " " + this.VALUE;
    }

    @Override
    public boolean matches(World world, @Nullable BlockPos pos) {
        Integer actual = this.getActual(world, pos);
        return actual != null && this.COMPARATOR.apply(actual, this.VALUE);
    }

    @Nullable
    public abstract Integer getActual(World var1, @Nullable BlockPos var2);
}

