/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.config.util.environment;

import fathertoast.specialmobs.common.config.field.AbstractConfigField;
import fathertoast.specialmobs.common.config.file.TomlHelper;
import fathertoast.specialmobs.common.config.util.environment.AbstractEnvironment;
import fathertoast.specialmobs.common.config.util.environment.ComparisonOperator;
import fathertoast.specialmobs.common.core.SpecialMobs;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class CompareFloatEnvironment
extends AbstractEnvironment {
    public final ComparisonOperator COMPARATOR;
    public final float VALUE;

    public CompareFloatEnvironment(ComparisonOperator op, float value) {
        this.COMPARATOR = op;
        this.VALUE = value;
    }

    public CompareFloatEnvironment(AbstractConfigField field, String line) {
        if (line.isEmpty()) {
            this.COMPARATOR = ComparisonOperator.LESS_THAN;
            this.VALUE = 0.0f;
            SpecialMobs.LOG.warn("Invalid entry for {} \"{}\"! Not defined. Defaulting to \"{}\". Invalid entry: {}", field.getClass(), (Object)field.getKey(), (Object)this.value(), (Object)line);
        } else {
            ComparisonOperator op = ComparisonOperator.parse(line);
            if (op == null) {
                this.COMPARATOR = ComparisonOperator.LESS_THAN;
                SpecialMobs.LOG.warn("Invalid entry for {} \"{}\"! Comparison not defined (must be in the set [ {} ]). Defaulting to \"{}\". Invalid entry: {}", field.getClass(), (Object)field.getKey(), (Object)TomlHelper.literalList((Object[])ComparisonOperator.values()), (Object)this.COMPARATOR, (Object)line);
            } else {
                this.COMPARATOR = op;
            }
            this.VALUE = this.parseValue(field, line, line.substring(this.COMPARATOR.toString().length()).trim());
        }
    }

    private float parseValue(AbstractConfigField field, String line, String arg) {
        float value;
        try {
            value = Float.parseFloat(arg);
        }
        catch (NumberFormatException ex) {
            SpecialMobs.LOG.warn("Invalid entry for {} \"{}\"! Value not defined (must be a float). Defaulting to '0'. Invalid entry: {}", field.getClass(), (Object)field.getKey(), (Object)line);
            value = 0.0f;
        }
        if (value < this.getMinValue()) {
            SpecialMobs.LOG.warn("Value for {} \"{}\" is below the minimum ({})! Clamping value. Invalid value: {}", field.getClass(), (Object)field.getKey(), (Object)Float.valueOf(this.getMinValue()), (Object)Float.valueOf(value));
            value = this.getMinValue();
        } else if (value > this.getMaxValue()) {
            SpecialMobs.LOG.warn("Value for {} \"{}\" is above the maximum ({})! Clamping value. Invalid value: {}", field.getClass(), (Object)field.getKey(), (Object)Float.valueOf(this.getMaxValue()), (Object)Float.valueOf(value));
            value = this.getMaxValue();
        }
        return value;
    }

    protected float getMinValue() {
        return Float.NEGATIVE_INFINITY;
    }

    protected float getMaxValue() {
        return Float.POSITIVE_INFINITY;
    }

    @Override
    public String value() {
        return (Object)((Object)this.COMPARATOR) + " " + this.VALUE;
    }

    @Override
    public boolean matches(World world, @Nullable BlockPos pos) {
        float actual = this.getActual(world, pos);
        return !Float.isNaN(actual) && this.COMPARATOR.apply(actual, this.VALUE);
    }

    public abstract float getActual(World var1, @Nullable BlockPos var2);
}

