/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.config.util;

import fathertoast.specialmobs.common.config.field.IntField;
import fathertoast.specialmobs.common.config.file.ToastConfigSpec;
import fathertoast.specialmobs.common.config.file.TomlHelper;
import fathertoast.specialmobs.common.core.SpecialMobs;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;

public class WeightedList<T extends Value> {
    private final List<Entry<T>> ENTRIES;
    private int totalWeight;

    public WeightedList(ToastConfigSpec SPEC, String key, T[] values, String ... description) {
        this(SPEC, key, Arrays.asList(values), description);
    }

    public WeightedList(ToastConfigSpec SPEC, String key, Iterable<T> values, String ... description) {
        IntField.Range fieldRange = IntField.Range.NON_NEGATIVE;
        if (description != null) {
            ArrayList<String> comment = TomlHelper.newComment(description);
            comment.add(TomlHelper.multiFieldInfo(fieldRange));
            SPEC.comment(comment);
        }
        ArrayList list = new ArrayList();
        for (Value value : values) {
            list.add(new Entry(value, SPEC.define(new IntField(key + "." + value.getKey(), value.getDefaultWeight(), fieldRange, value.getComment())), null));
        }
        this.ENTRIES = Collections.unmodifiableList(list);
        SPEC.callback(this::recalculateTotalWeight);
    }

    @Nullable
    public T next(Random random) {
        if (this.isDisabled()) {
            return null;
        }
        int choice = random.nextInt(this.totalWeight);
        for (Entry<T> entry : this.ENTRIES) {
            if ((choice -= entry.getWeight()) >= 0) continue;
            return entry.getValue();
        }
        SpecialMobs.LOG.error("Weighting error occurred while rolling random item! This may have been caused by configs reloading during random roll (comod). Otherwise, it is very bad. :(");
        return null;
    }

    public boolean isDisabled() {
        return this.totalWeight <= 0;
    }

    public void recalculateTotalWeight() {
        int weight = 0;
        for (Entry<T> entry : this.ENTRIES) {
            weight += entry.getWeight();
        }
        this.totalWeight = weight;
    }

    public static interface Value {
        public String getKey();

        default public int getDefaultWeight() {
            return 1;
        }

        @Nullable
        default public String[] getComment() {
            return null;
        }
    }

    private static class Entry<T extends Value> {
        private final T VALUE;
        private final IntField WEIGHT;

        private Entry(T value, IntField weight) {
            this.VALUE = value;
            this.WEIGHT = weight;
        }

        T getValue() {
            return this.VALUE;
        }

        int getWeight() {
            return this.WEIGHT.get();
        }

        /* synthetic */ Entry(Value x0, IntField x1, 1 x2) {
            this(x0, x1);
        }
    }
}

